EESchema Schematic File Version 4
LIBS:LCg-1 v5-cache
EELAYER 30 0
EELAYER END
$Descr User 8661 6693
encoding utf-8
Sheet 1 1
Title "LCg-1. Structural LC Oscillator. Base structure"
Date "2020-04-18"
Rev "5cc"
Comp "Aleksander Burd"
Comment1 "Licence: Creative Commons, BY"
Comment2 "Parallel resonant circuit"
Comment3 "Easy to use LC sinus oscillator"
Comment4 ""
$EndDescr
$Comp
L pspice:INDUCTOR L1
U 1 1 5CBC64CD
P 3900 2000
F 0 "L1" V 3854 2078 50  0000 L CNN
F 1 "Lr" V 3750 2075 50  0000 L CNN
F 2 "AB-lib-foot:R_1206_AB" H 3900 2000 50  0001 C CNN
F 3 "~" H 3900 2000 50  0001 C CNN
	1    3900 2000
	0    1    1    0   
$EndComp
$Comp
L Device:C C4
U 1 1 5CBC65D8
P 2875 1725
F 0 "C4" H 2990 1771 50  0000 L CNN
F 1 "47n" H 2990 1680 50  0000 L CNN
F 2 "AB-lib-foot:R_0805_AB" H 2913 1575 50  0001 C CNN
F 3 "~" H 2875 1725 50  0001 C CNN
	1    2875 1725
	1    0    0    -1  
$EndComp
$Comp
L Device:C Cd1
U 1 1 5CBC66D2
P 2100 4000
F 0 "Cd1" H 1825 4050 50  0000 L CNN
F 1 "Cdet" H 1825 3925 50  0000 L CNN
F 2 "AB-lib-foot:R_0805_AB" H 2138 3850 50  0001 C CNN
F 3 "~" H 2100 4000 50  0001 C CNN
	1    2100 4000
	1    0    0    -1  
$EndComp
$Comp
L Device:R R8
U 1 1 5CBC68C8
P 3600 4000
F 0 "R8" H 3670 4046 50  0000 L CNN
F 1 "330" H 3670 3955 50  0000 L CNN
F 2 "AB-lib-foot:R_0805_AB" V 3530 4000 50  0001 C CNN
F 3 "~" H 3600 4000 50  0001 C CNN
	1    3600 4000
	1    0    0    -1  
$EndComp
$Comp
L Device:R R7
U 1 1 5CBC6986
P 3225 3775
F 0 "R7" V 3018 3775 50  0000 C CNN
F 1 "2k2" V 3109 3775 50  0000 C CNN
F 2 "AB-lib-foot:R_0805_AB" V 3155 3775 50  0001 C CNN
F 3 "~" H 3225 3775 50  0001 C CNN
	1    3225 3775
	0    1    1    0   
$EndComp
$Comp
L Device:R R18
U 1 1 5CBC69DA
P 5675 3975
F 0 "R18" H 5745 4021 50  0000 L CNN
F 1 "470" H 5745 3930 50  0000 L CNN
F 2 "AB-lib-foot:R_0805_AB" V 5605 3975 50  0001 C CNN
F 3 "~" H 5675 3975 50  0001 C CNN
	1    5675 3975
	1    0    0    -1  
$EndComp
$Comp
L Device:R R5
U 1 1 5CBC6BBA
P 3150 3350
F 0 "R5" V 2943 3350 50  0000 C CNN
F 1 "33" V 3034 3350 50  0000 C CNN
F 2 "AB-lib-foot:R_0805_AB" V 3080 3350 50  0001 C CNN
F 3 "~" H 3150 3350 50  0001 C CNN
	1    3150 3350
	0    1    1    0   
$EndComp
$Comp
L Device:R R15
U 1 1 5CBC6C16
P 5225 2625
F 0 "R15" V 5018 2625 50  0000 C CNN
F 1 "68" V 5109 2625 50  0000 C CNN
F 2 "AB-lib-foot:R_0603_AB" V 5155 2625 50  0001 C CNN
F 3 "~" H 5225 2625 50  0001 C CNN
	1    5225 2625
	0    1    1    0   
$EndComp
$Comp
L Device:R R1
U 1 1 5CBC6CA8
P 1500 3100
F 0 "R1" H 1600 3250 50  0000 C CNN
F 1 "3k3" H 1625 3150 50  0000 C CNN
F 2 "AB-lib-foot:R_0603_AB" V 1430 3100 50  0001 C CNN
F 3 "~" H 1500 3100 50  0001 C CNN
	1    1500 3100
	1    0    0    -1  
$EndComp
$Comp
L Device:R R21
U 1 1 5CBC6D08
P 6825 3300
F 0 "R21" V 6618 3300 50  0000 C CNN
F 1 "120" V 6709 3300 50  0000 C CNN
F 2 "AB-lib-foot:R_0805_AB" V 6755 3300 50  0001 C CNN
F 3 "~" H 6825 3300 50  0001 C CNN
	1    6825 3300
	0    1    1    0   
$EndComp
$Comp
L Device:C C18
U 1 1 5CBC6D8C
P 7200 3300
F 0 "C18" V 6948 3300 50  0000 C CNN
F 1 "47n" V 7039 3300 50  0000 C CNN
F 2 "AB-lib-foot:R_0805_AB" H 7238 3150 50  0001 C CNN
F 3 "~" H 7200 3300 50  0001 C CNN
	1    7200 3300
	0    1    1    0   
$EndComp
$Comp
L Device:R R13
U 1 1 5CBC7184
P 4850 1525
F 0 "R13" H 4920 1571 50  0000 L CNN
F 1 "5k6" H 4920 1480 50  0000 L CNN
F 2 "AB-lib-foot:R_0805_AB" V 4780 1525 50  0001 C CNN
F 3 "~" H 4850 1525 50  0001 C CNN
	1    4850 1525
	1    0    0    -1  
$EndComp
$Comp
L Device:C C13
U 1 1 5CBC7364
P 5225 1525
F 0 "C13" H 5250 1625 50  0000 L CNN
F 1 "10n" H 5250 1425 50  0000 L CNN
F 2 "AB-lib-foot:R_0805_AB" H 5263 1375 50  0001 C CNN
F 3 "~" H 5225 1525 50  0001 C CNN
	1    5225 1525
	1    0    0    -1  
$EndComp
$Comp
L Device:C C14
U 1 1 5CBC759F
P 6000 1450
F 0 "C14" H 6115 1496 50  0000 L CNN
F 1 "2n2" H 6115 1405 50  0000 L CNN
F 2 "AB-lib-foot:R_0805_AB" H 6038 1300 50  0001 C CNN
F 3 "~" H 6000 1450 50  0001 C CNN
	1    6000 1450
	1    0    0    -1  
$EndComp
$Comp
L Device:CP C3
U 1 1 5CBC69AC
P 4375 1550
F 0 "C3" H 4493 1596 50  0000 L CNN
F 1 "22u" H 4493 1505 50  0000 L CNN
F 2 "AB-lib-foot:CNE_Radial_D5.0mm_P2.50mm" H 4413 1400 50  0001 C CNN
F 3 "~" H 4375 1550 50  0001 C CNN
	1    4375 1550
	1    0    0    -1  
$EndComp
$Comp
L Device:CP C16
U 1 1 5CBC6A86
P 6775 1325
F 0 "C16" H 6893 1371 50  0000 L CNN
F 1 "22u" H 6893 1280 50  0000 L CNN
F 2 "AB-lib-foot:CNE_Radial_D5.0mm_P2.50mm" H 6813 1175 50  0001 C CNN
F 3 "~" H 6775 1325 50  0001 C CNN
	1    6775 1325
	1    0    0    -1  
$EndComp
Wire Wire Line
	3900 1700 3900 1750
Connection ~ 3600 2250
Wire Wire Line
	3900 2250 3600 2250
Wire Wire Line
	3600 1575 3600 1700
Connection ~ 3600 1700
Wire Wire Line
	3600 1700 3900 1700
$Comp
L Device:C C12
U 1 1 5CBC8604
P 5300 3550
F 0 "C12" V 5048 3550 50  0000 C CNN
F 1 "47n" V 5139 3550 50  0000 C CNN
F 2 "AB-lib-foot:R_0805_AB" H 5338 3400 50  0001 C CNN
F 3 "~" H 5300 3550 50  0001 C CNN
	1    5300 3550
	0    1    1    0   
$EndComp
Wire Wire Line
	6975 3300 7050 3300
Wire Wire Line
	2875 1575 3250 1575
Wire Wire Line
	5675 1300 5675 1400
$Comp
L Device:C C9
U 1 1 5CBD248B
P 4550 4150
F 0 "C9" H 4375 4275 50  0000 L CNN
F 1 "100n" H 4325 4050 50  0000 L CNN
F 2 "AB-lib-foot:R_0805_AB" H 4588 4000 50  0001 C CNN
F 3 "~" H 4550 4150 50  0001 C CNN
	1    4550 4150
	1    0    0    -1  
$EndComp
$Comp
L Device:C C6
U 1 1 5CBD50FC
P 3250 1925
F 0 "C6" H 3365 1971 50  0000 L CNN
F 1 "Cr1" H 3365 1880 50  0000 L CNN
F 2 "AB-lib-foot:R_1206_AB" H 3288 1775 50  0001 C CNN
F 3 "~" H 3250 1925 50  0001 C CNN
	1    3250 1925
	1    0    0    -1  
$EndComp
Wire Wire Line
	3250 2250 3250 2075
Wire Wire Line
	3250 1775 3250 1700
Text Notes 2950 4100 0    50   ~ 0
equivalent:\n1.5V, 280ohm.\nIstart=5.3mA
Text Notes 5675 3175 0    50   ~ 0
15mA
$Comp
L Device:C C15
U 1 1 5CBEB2C7
P 6100 2050
F 0 "C15" V 5848 2050 50  0000 C CNN
F 1 "47n" V 5939 2050 50  0000 C CNN
F 2 "AB-lib-foot:R_0805_AB" H 6138 1900 50  0001 C CNN
F 3 "~" H 6100 2050 50  0001 C CNN
	1    6100 2050
	0    1    1    0   
$EndComp
$Comp
L Device:R Rd1
U 1 1 5CBF09F1
P 2350 4000
F 0 "Rd1" H 2420 4046 50  0000 L CNN
F 1 "10*" H 2420 3955 50  0000 L CNN
F 2 "AB-lib-foot:R_0805_AB" V 2280 4000 50  0001 C CNN
F 3 "~" H 2350 4000 50  0001 C CNN
	1    2350 4000
	1    0    0    -1  
$EndComp
$Comp
L Device:R R6
U 1 1 5CBF1935
P 2800 4475
F 0 "R6" V 2593 4475 50  0000 C CNN
F 1 "56" V 2684 4475 50  0000 C CNN
F 2 "AB-lib-foot:R_0805_AB" V 2730 4475 50  0001 C CNN
F 3 "~" H 2800 4475 50  0001 C CNN
	1    2800 4475
	0    1    1    0   
$EndComp
$Comp
L Connector_Generic:Conn_01x01 J3
U 1 1 5CBF8380
P 6900 2050
F 0 "J3" H 6979 2092 50  0000 L CNN
F 1 "Outf" H 6979 2001 50  0000 L CNN
F 2 "AB-lib-foot:ts70" H 6900 2050 50  0001 C CNN
F 3 "~" H 6900 2050 50  0001 C CNN
	1    6900 2050
	1    0    0    -1  
$EndComp
Wire Wire Line
	2350 4825 2350 4675
$Comp
L Connector_Generic:Conn_01x01 J2
U 1 1 5CBE3061
P 6900 1750
F 0 "J2" H 6979 1792 50  0000 L CNN
F 1 "Of-G" H 6979 1701 50  0000 L CNN
F 2 "AB-lib-foot:ts70" H 6900 1750 50  0001 C CNN
F 3 "~" H 6900 1750 50  0001 C CNN
	1    6900 1750
	1    0    0    -1  
$EndComp
$Comp
L Device:C C5
U 1 1 5CD23978
P 3250 1425
F 0 "C5" H 3365 1471 50  0000 L CNN
F 1 "1n" H 3365 1380 50  0000 L CNN
F 2 "AB-lib-foot:R_0805_AB" H 3288 1275 50  0001 C CNN
F 3 "~" H 3250 1425 50  0001 C CNN
	1    3250 1425
	1    0    0    -1  
$EndComp
Connection ~ 3250 1575
Wire Wire Line
	3250 1575 3600 1575
$Comp
L Device:C C2
U 1 1 5CD7CCE1
P 975 2700
F 0 "C2" H 1090 2746 50  0000 L CNN
F 1 "10n" H 1090 2655 50  0000 L CNN
F 2 "AB-lib-foot:R_0805_AB" H 1013 2550 50  0001 C CNN
F 3 "~" H 975 2700 50  0001 C CNN
	1    975  2700
	1    0    0    -1  
$EndComp
Wire Wire Line
	4325 3550 4650 3550
$Comp
L Device:C C10
U 1 1 5CBC6EBA
P 4325 2625
F 0 "C10" V 4073 2625 50  0000 C CNN
F 1 "47n" V 4164 2625 50  0000 C CNN
F 2 "AB-lib-foot:R_0805_AB" H 4363 2475 50  0001 C CNN
F 3 "~" H 4325 2625 50  0001 C CNN
	1    4325 2625
	0    1    1    0   
$EndComp
$Comp
L AB_Library-sch:GND #PWR07
U 1 1 5D17A14F
P 4375 1750
F 0 "#PWR07" H 4325 1800 50  0001 C CNN
F 1 "GND" H 4375 1700 50  0001 C CNN
F 2 "" H 4375 1750 50  0001 C CNN
F 3 "" H 4375 1750 50  0001 C CNN
	1    4375 1750
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:GND #PWR09
U 1 1 5D17A662
P 2875 1925
F 0 "#PWR09" H 2825 1975 50  0001 C CNN
F 1 "GND" H 2875 1875 50  0001 C CNN
F 2 "" H 2875 1925 50  0001 C CNN
F 3 "" H 2875 1925 50  0001 C CNN
	1    2875 1925
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:GND #PWR011
U 1 1 5D17AB17
P 3250 1225
F 0 "#PWR011" H 3200 1275 50  0001 C CNN
F 1 "GND" H 3250 1175 50  0001 C CNN
F 2 "" H 3250 1225 50  0001 C CNN
F 3 "" H 3250 1225 50  0001 C CNN
	1    3250 1225
	-1   0    0    1   
$EndComp
$Comp
L AB_Library-sch:GND #PWR05
U 1 1 5D17DF5A
P 2100 4200
F 0 "#PWR05" H 2050 4250 50  0001 C CNN
F 1 "GND" H 2100 4150 50  0001 C CNN
F 2 "" H 2100 4200 50  0001 C CNN
F 3 "" H 2100 4200 50  0001 C CNN
	1    2100 4200
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:GND #PWR04
U 1 1 5D17F870
P 975 2900
F 0 "#PWR04" H 925 2950 50  0001 C CNN
F 1 "GND" H 975 2850 50  0001 C CNN
F 2 "" H 975 2900 50  0001 C CNN
F 3 "" H 975 2900 50  0001 C CNN
	1    975  2900
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:GND #PWR036
U 1 1 5D18146C
P 7450 3575
F 0 "#PWR036" H 7400 3625 50  0001 C CNN
F 1 "GND" H 7450 3525 50  0001 C CNN
F 2 "" H 7450 3575 50  0001 C CNN
F 3 "" H 7450 3575 50  0001 C CNN
	1    7450 3575
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:GND #PWR031
U 1 1 5D181ABF
P 6650 1750
F 0 "#PWR031" H 6600 1800 50  0001 C CNN
F 1 "GND" H 6650 1700 50  0001 C CNN
F 2 "" H 6650 1750 50  0001 C CNN
F 3 "" H 6650 1750 50  0001 C CNN
	1    6650 1750
	0    1    1    0   
$EndComp
$Comp
L AB_Library-sch:GND #PWR026
U 1 1 5D182009
P 6000 1650
F 0 "#PWR026" H 5950 1700 50  0001 C CNN
F 1 "GND" H 6000 1600 50  0001 C CNN
F 2 "" H 6000 1650 50  0001 C CNN
F 3 "" H 6000 1650 50  0001 C CNN
	1    6000 1650
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:GND #PWR018
U 1 1 5D182990
P 4550 4350
F 0 "#PWR018" H 4500 4400 50  0001 C CNN
F 1 "GND" H 4550 4300 50  0001 C CNN
F 2 "" H 4550 4350 50  0001 C CNN
F 3 "" H 4550 4350 50  0001 C CNN
	1    4550 4350
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:GND #PWR022
U 1 1 5D182B82
P 5225 1725
F 0 "#PWR022" H 5175 1775 50  0001 C CNN
F 1 "GND" H 5225 1675 50  0001 C CNN
F 2 "" H 5225 1725 50  0001 C CNN
F 3 "" H 5225 1725 50  0001 C CNN
	1    5225 1725
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:GND #PWR028
U 1 1 5D183065
P 6775 1525
F 0 "#PWR028" H 6725 1575 50  0001 C CNN
F 1 "GND" H 6775 1475 50  0001 C CNN
F 2 "" H 6775 1525 50  0001 C CNN
F 3 "" H 6775 1525 50  0001 C CNN
	1    6775 1525
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:GND #PWR033
U 1 1 5D183649
P 7100 1525
F 0 "#PWR033" H 7050 1575 50  0001 C CNN
F 1 "GND" H 7100 1475 50  0001 C CNN
F 2 "" H 7100 1525 50  0001 C CNN
F 3 "" H 7100 1525 50  0001 C CNN
	1    7100 1525
	1    0    0    -1  
$EndComp
$Comp
L Device:R R3
U 1 1 5D1891B0
P 1150 3350
F 0 "R3" V 1025 3325 50  0000 L CNN
F 1 "10k" V 1250 3300 50  0000 L CNN
F 2 "AB-lib-foot:R_0805_AB" V 1080 3350 50  0001 C CNN
F 3 "~" H 1150 3350 50  0001 C CNN
	1    1150 3350
	0    1    1    0   
$EndComp
$Comp
L Connector_Generic:Conn_01x01 J1
U 1 1 5D18E8FB
P 800 3350
F 0 "J1" H 879 3392 50  0000 L CNN
F 1 "Vdet" H 879 3301 50  0000 L CNN
F 2 "AB-lib-foot:ts70" H 800 3350 50  0001 C CNN
F 3 "~" H 800 3350 50  0001 C CNN
	1    800  3350
	-1   0    0    1   
$EndComp
Wire Wire Line
	3600 3550 3600 3775
Wire Wire Line
	3600 3550 4025 3550
$Comp
L AB_Library-sch:NPN_smd Q1
U 1 1 5D50CADD
P 3500 3350
F 0 "Q1" H 3691 3396 50  0000 L CNN
F 1 "BFS17A" H 3691 3305 50  0000 L CNN
F 2 "AB-lib-foot:SOT-23" H 3440 3180 50  0001 C CNN
F 3 "~" H 3500 3350 50  0001 C CNN
	1    3500 3350
	1    0    0    -1  
$EndComp
Connection ~ 3600 3550
$Comp
L Device:R R17
U 1 1 5CBC6852
P 5675 1550
F 0 "R17" H 5745 1596 50  0000 L CNN
F 1 "33" H 5745 1505 50  0000 L CNN
F 2 "AB-lib-foot:R_0805_AB" V 5605 1550 50  0001 C CNN
F 3 "~" H 5675 1550 50  0001 C CNN
	1    5675 1550
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:NPN_smd Q2
U 1 1 5D5396F8
P 5575 2625
F 0 "Q2" H 5766 2671 50  0000 L CNN
F 1 "BFS17A" H 5766 2580 50  0000 L CNN
F 2 "AB-lib-foot:SOT-23" H 5515 2455 50  0001 C CNN
F 3 "~" H 5575 2625 50  0001 C CNN
	1    5575 2625
	1    0    0    -1  
$EndComp
Wire Wire Line
	3600 2250 3600 2625
Connection ~ 3600 2625
Wire Wire Line
	3600 2625 3600 3150
$Comp
L Device:R R14
U 1 1 5D57D3C5
P 4850 2900
F 0 "R14" H 4920 2946 50  0000 L CNN
F 1 "10k" H 4920 2855 50  0000 L CNN
F 2 "AB-lib-foot:R_0805_AB" V 4780 2900 50  0001 C CNN
F 3 "~" H 4850 2900 50  0001 C CNN
	1    4850 2900
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:GND #PWR020
U 1 1 5D57DA3E
P 4850 3100
F 0 "#PWR020" H 4800 3150 50  0001 C CNN
F 1 "GND" H 4850 3050 50  0001 C CNN
F 2 "" H 4850 3100 50  0001 C CNN
F 3 "" H 4850 3100 50  0001 C CNN
	1    4850 3100
	1    0    0    -1  
$EndComp
Wire Wire Line
	4850 2750 4850 2625
Connection ~ 4850 2625
Wire Wire Line
	4850 2625 4475 2625
Wire Wire Line
	4850 2625 4850 1675
Wire Wire Line
	5075 2625 4850 2625
Wire Wire Line
	5675 2425 5675 2050
$Comp
L AB_Library-sch:+12V #PWR027
U 1 1 5D5B4166
P 6775 1175
F 0 "#PWR027" H 6775 1025 50  0001 C CNN
F 1 "+12V" H 6791 1356 50  0000 C CNN
F 2 "" H 6775 1175 50  0001 C CNN
F 3 "" H 6775 1175 50  0001 C CNN
	1    6775 1175
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:+12V #PWR012
U 1 1 5D5B9E0D
P 3600 1425
F 0 "#PWR012" H 3600 1275 50  0001 C CNN
F 1 "+12V" H 3616 1606 50  0000 C CNN
F 2 "" H 3600 1425 50  0001 C CNN
F 3 "" H 3600 1425 50  0001 C CNN
	1    3600 1425
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:+12V #PWR03
U 1 1 5D5BAB61
P 975 2550
F 0 "#PWR03" H 975 2400 50  0001 C CNN
F 1 "+12V" H 991 2731 50  0000 C CNN
F 2 "" H 975 2550 50  0001 C CNN
F 3 "" H 975 2550 50  0001 C CNN
	1    975  2550
	1    0    0    -1  
$EndComp
Wire Wire Line
	5675 2825 5675 2850
$Comp
L Device:R R12
U 1 1 5CBC8580
P 4175 3550
F 0 "R12" V 3968 3550 50  0000 C CNN
F 1 "75*" V 4059 3550 50  0000 C CNN
F 2 "AB-lib-foot:R_0805_AB" V 4105 3550 50  0001 C CNN
F 3 "~" H 4175 3550 50  0001 C CNN
	1    4175 3550
	0    1    1    0   
$EndComp
$Comp
L AB_Library-sch:GND #PWR024
U 1 1 5D5C90E4
P 5675 4175
F 0 "#PWR024" H 5625 4225 50  0001 C CNN
F 1 "GND" H 5675 4125 50  0001 C CNN
F 2 "" H 5675 4175 50  0001 C CNN
F 3 "" H 5675 4175 50  0001 C CNN
	1    5675 4175
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:+12V #PWR019
U 1 1 5D5CB241
P 4850 1375
F 0 "#PWR019" H 4850 1225 50  0001 C CNN
F 1 "+12V" H 4866 1556 50  0000 C CNN
F 2 "" H 4850 1375 50  0001 C CNN
F 3 "" H 4850 1375 50  0001 C CNN
	1    4850 1375
	1    0    0    -1  
$EndComp
Wire Wire Line
	6700 2050 6250 2050
Connection ~ 5675 2050
Wire Wire Line
	5675 2050 5675 1700
$Comp
L AB_Library-sch:+12V #PWR023
U 1 1 5D5F70F3
P 5675 1300
F 0 "#PWR023" H 5675 1150 50  0001 C CNN
F 1 "+12V" H 5691 1481 50  0000 C CNN
F 2 "" H 5675 1300 50  0001 C CNN
F 3 "" H 5675 1300 50  0001 C CNN
	1    5675 1300
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:NPN_smd Q4
U 1 1 5D6036D5
P 6500 2850
F 0 "Q4" H 6691 2896 50  0000 L CNN
F 1 "BFS17A" H 6691 2805 50  0000 L CNN
F 2 "AB-lib-foot:SOT-23" H 6440 2680 50  0001 C CNN
F 3 "~" H 6500 2850 50  0001 C CNN
	1    6500 2850
	1    0    0    -1  
$EndComp
$Comp
L Device:R R19
U 1 1 5D6040C7
P 6150 2850
F 0 "R19" V 6050 2875 50  0000 C CNN
F 1 "33" V 6275 2825 50  0000 C CNN
F 2 "AB-lib-foot:R_0603_AB" V 6080 2850 50  0001 C CNN
F 3 "~" H 6150 2850 50  0001 C CNN
	1    6150 2850
	0    1    1    0   
$EndComp
$Comp
L AB_Library-sch:GND #PWR08
U 1 1 5D6224DC
P 2350 4875
F 0 "#PWR08" H 2300 4925 50  0001 C CNN
F 1 "GND" H 2350 4825 50  0001 C CNN
F 2 "" H 2350 4875 50  0001 C CNN
F 3 "" H 2350 4875 50  0001 C CNN
	1    2350 4875
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:PR PR1
U 1 1 5D62BADB
P 4825 3550
F 0 "PR1" V 4570 3550 50  0000 C CNN
F 1 "2k2" V 4661 3550 50  0000 C CNN
F 2 "AB-lib-foot:npr-v" H 4825 3550 50  0001 C CNN
F 3 "~" H 4825 3550 50  0001 C CNN
	1    4825 3550
	0    1    -1   0   
$EndComp
Wire Wire Line
	4975 3550 5150 3550
Wire Wire Line
	4825 3400 4650 3400
Wire Wire Line
	4650 3400 4650 3550
Connection ~ 4650 3550
Wire Wire Line
	4650 3550 4675 3550
Wire Wire Line
	6000 2850 5675 2850
Connection ~ 5675 2850
Wire Wire Line
	5675 2850 5675 3550
Connection ~ 5675 3550
Wire Wire Line
	5675 3550 5675 3825
$Comp
L AB_Library-sch:GND #PWR013
U 1 1 5D6894ED
P 3600 4200
F 0 "#PWR013" H 3550 4250 50  0001 C CNN
F 1 "GND" H 3600 4150 50  0001 C CNN
F 2 "" H 3600 4200 50  0001 C CNN
F 3 "" H 3600 4200 50  0001 C CNN
	1    3600 4200
	1    0    0    -1  
$EndComp
$Comp
L Device:R R20
U 1 1 5D68B650
P 6600 3900
F 0 "R20" H 6670 3946 50  0000 L CNN
F 1 "470" H 6670 3855 50  0000 L CNN
F 2 "AB-lib-foot:R_0805_AB" V 6530 3900 50  0001 C CNN
F 3 "~" H 6600 3900 50  0001 C CNN
	1    6600 3900
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:GND #PWR030
U 1 1 5D68BF4A
P 6600 4100
F 0 "#PWR030" H 6550 4150 50  0001 C CNN
F 1 "GND" H 6600 4050 50  0001 C CNN
F 2 "" H 6600 4100 50  0001 C CNN
F 3 "" H 6600 4100 50  0001 C CNN
	1    6600 4100
	1    0    0    -1  
$EndComp
Wire Wire Line
	6600 3050 6600 3300
Wire Wire Line
	6675 3300 6600 3300
Connection ~ 6600 3300
Wire Wire Line
	6600 3300 6600 3750
Wire Wire Line
	6000 4475 6000 3550
Wire Wire Line
	6000 3550 5675 3550
$Comp
L AB_Library-sch:+12V #PWR029
U 1 1 5D6B7A47
P 6600 2650
F 0 "#PWR029" H 6600 2500 50  0001 C CNN
F 1 "+12V" H 6616 2831 50  0000 C CNN
F 2 "" H 6600 2650 50  0001 C CNN
F 3 "" H 6600 2650 50  0001 C CNN
	1    6600 2650
	1    0    0    -1  
$EndComp
Wire Wire Line
	3600 1575 3600 1425
Connection ~ 3600 1575
$Comp
L Device:C C7
U 1 1 5CBC6541
P 3600 2050
F 0 "C7" H 3715 2096 50  0000 L CNN
F 1 "Cr2" H 3715 2005 50  0000 L CNN
F 2 "AB-lib-foot:R_0805_AB" H 3638 1900 50  0001 C CNN
F 3 "~" H 3600 2050 50  0001 C CNN
	1    3600 2050
	1    0    0    -1  
$EndComp
Wire Wire Line
	3250 1700 3600 1700
Wire Wire Line
	3250 2250 3600 2250
Wire Wire Line
	3600 1900 3600 1700
Wire Wire Line
	3600 2200 3600 2250
$Comp
L AB_Library-sch:+12V #PWR017
U 1 1 5D6DCCF1
P 4550 4000
F 0 "#PWR017" H 4550 3850 50  0001 C CNN
F 1 "+12V" H 4566 4181 50  0000 C CNN
F 2 "" H 4550 4000 50  0001 C CNN
F 3 "" H 4550 4000 50  0001 C CNN
	1    4550 4000
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:+12V #PWR06
U 1 1 5D6DD1A4
P 4375 1400
F 0 "#PWR06" H 4375 1250 50  0001 C CNN
F 1 "+12V" H 4391 1581 50  0000 C CNN
F 2 "" H 4375 1400 50  0001 C CNN
F 3 "" H 4375 1400 50  0001 C CNN
	1    4375 1400
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:+12V #PWR025
U 1 1 5D6ECB08
P 6000 1300
F 0 "#PWR025" H 6000 1150 50  0001 C CNN
F 1 "+12V" H 6016 1481 50  0000 C CNN
F 2 "" H 6000 1300 50  0001 C CNN
F 3 "" H 6000 1300 50  0001 C CNN
	1    6000 1300
	1    0    0    -1  
$EndComp
Wire Wire Line
	7100 1275 7100 1475
Wire Wire Line
	5950 2050 5675 2050
$Comp
L AB_Library-sch:+12V #PWR01
U 1 1 5D713FDB
P 1500 2875
F 0 "#PWR01" H 1500 2725 50  0001 C CNN
F 1 "+12V" H 1516 3056 50  0000 C CNN
F 2 "" H 1500 2875 50  0001 C CNN
F 3 "" H 1500 2875 50  0001 C CNN
	1    1500 2875
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:GND #PWR02
U 1 1 5D72F61A
P 1500 3775
F 0 "#PWR02" H 1450 3825 50  0001 C CNN
F 1 "GND" H 1500 3725 50  0001 C CNN
F 2 "" H 1500 3775 50  0001 C CNN
F 3 "" H 1500 3775 50  0001 C CNN
	1    1500 3775
	1    0    0    -1  
$EndComp
Wire Wire Line
	1500 3425 1500 3350
Connection ~ 1500 3350
Wire Wire Line
	1500 3350 2100 3350
Wire Wire Line
	2100 3850 2100 3350
Connection ~ 2100 3350
$Comp
L Device:R R2
U 1 1 5CBE4942
P 1500 3575
F 0 "R2" H 1570 3621 50  0000 L CNN
F 1 "1k5" H 1570 3530 50  0000 L CNN
F 2 "AB-lib-foot:R_0805_AB" V 1430 3575 50  0001 C CNN
F 3 "~" H 1500 3575 50  0001 C CNN
	1    1500 3575
	1    0    0    -1  
$EndComp
Text Notes 1750 3100 0    50   ~ 0
equivalent:\n3.7V
$Comp
L Device:C C11
U 1 1 5D744456
P 4950 4475
F 0 "C11" V 4698 4475 50  0000 C CNN
F 1 "47n" V 4789 4475 50  0000 C CNN
F 2 "AB-lib-foot:R_0805_AB" H 4988 4325 50  0001 C CNN
F 3 "~" H 4950 4475 50  0001 C CNN
	1    4950 4475
	0    1    1    0   
$EndComp
Wire Wire Line
	5100 4475 6000 4475
Text Notes 3425 4475 0    50   ~ 0
3.7V
$Comp
L AB_Library-sch:+12V #PWR010
U 1 1 5D769388
P 2875 3775
F 0 "#PWR010" H 2875 3625 50  0001 C CNN
F 1 "+12V" H 2891 3956 50  0000 C CNN
F 2 "" H 2875 3775 50  0001 C CNN
F 3 "" H 2875 3775 50  0001 C CNN
	1    2875 3775
	1    0    0    -1  
$EndComp
Wire Wire Line
	3075 3775 2875 3775
$Comp
L Device:C C17
U 1 1 5D782B11
P 7100 2750
F 0 "C17" H 7215 2796 50  0000 L CNN
F 1 "10n" H 7215 2705 50  0000 L CNN
F 2 "AB-lib-foot:R_0805_AB" H 7138 2600 50  0001 C CNN
F 3 "~" H 7100 2750 50  0001 C CNN
	1    7100 2750
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:GND #PWR035
U 1 1 5D782B17
P 7100 2950
F 0 "#PWR035" H 7050 3000 50  0001 C CNN
F 1 "GND" H 7100 2900 50  0001 C CNN
F 2 "" H 7100 2950 50  0001 C CNN
F 3 "" H 7100 2950 50  0001 C CNN
	1    7100 2950
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:+12V #PWR034
U 1 1 5D782B1D
P 7100 2600
F 0 "#PWR034" H 7100 2450 50  0001 C CNN
F 1 "+12V" H 7116 2781 50  0000 C CNN
F 2 "" H 7100 2600 50  0001 C CNN
F 3 "" H 7100 2600 50  0001 C CNN
	1    7100 2600
	1    0    0    -1  
$EndComp
Wire Wire Line
	1300 3350 1500 3350
Wire Wire Line
	4175 2625 3600 2625
$Comp
L AB_Library-sch:+12V #PWR0101
U 1 1 5D8385FE
P 5225 1375
F 0 "#PWR0101" H 5225 1225 50  0001 C CNN
F 1 "+12V" H 5241 1556 50  0000 C CNN
F 2 "" H 5225 1375 50  0001 C CNN
F 3 "" H 5225 1375 50  0001 C CNN
	1    5225 1375
	1    0    0    -1  
$EndComp
Text Notes 4875 2075 0    50   ~ 0
7.7V
Wire Wire Line
	5450 3550 5675 3550
$Comp
L AB_Library-sch:PNP_smd Q3
U 1 1 5E9C112D
P 2450 4475
F 0 "Q3" H 2638 4521 50  0000 L CNN
F 1 "BF824" H 2638 4430 50  0000 L CNN
F 2 "AB-lib-foot:SOT-23" H 2550 4670 50  0001 C CNN
F 3 "~" H 2450 4475 50  0001 C CNN
	1    2450 4475
	-1   0    0    -1  
$EndComp
Wire Wire Line
	2950 4475 4075 4475
$Comp
L AB_Library-sch:ARK_02 J4
U 1 1 5EA13C38
P 7300 1275
F 0 "J4" H 7380 1367 50  0000 L CNN
F 1 "Supply" H 7380 1276 50  0000 L CNN
F 2 "AB-lib-foot:ak550_2" H 7300 1275 50  0001 C CNN
F 3 "~" H 7300 1275 50  0001 C CNN
	1    7300 1275
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:ARK_02 J6
U 1 1 5EA15D84
P 7650 3400
F 0 "J6" H 7730 3492 50  0000 L CNN
F 1 "Out" H 7730 3401 50  0000 L CNN
F 2 "AB-lib-foot:ak550_2" H 7650 3400 50  0001 C CNN
F 3 "~" H 7650 3400 50  0001 C CNN
	1    7650 3400
	1    0    0    -1  
$EndComp
Wire Wire Line
	7350 3300 7450 3300
Wire Wire Line
	7450 3525 7450 3400
$Comp
L Device:R R10
U 1 1 5EA2BFD1
P 7050 3900
F 0 "R10" H 7120 3946 50  0000 L CNN
F 1 "82" H 7120 3855 50  0000 L CNN
F 2 "AB-lib-foot:R_0805_AB" V 6980 3900 50  0001 C CNN
F 3 "~" H 7050 3900 50  0001 C CNN
	1    7050 3900
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:GND #PWR016
U 1 1 5EA2C538
P 7050 4100
F 0 "#PWR016" H 7000 4150 50  0001 C CNN
F 1 "GND" H 7050 4050 50  0001 C CNN
F 2 "" H 7050 4100 50  0001 C CNN
F 3 "" H 7050 4100 50  0001 C CNN
	1    7050 4100
	1    0    0    -1  
$EndComp
Wire Wire Line
	7050 3750 7050 3300
Connection ~ 7050 3300
Wire Notes Line
	7850 3800 7475 3800
Wire Notes Line
	7475 3800 7475 4125
Wire Notes Line
	7750 3750 7850 3800
Wire Notes Line
	7850 3800 7750 3850
Text Notes 7525 3950 0    50   ~ 0
50 ohm
$Comp
L Device:R R4
U 1 1 5EA82893
P 4075 4225
F 0 "R4" H 3950 4350 50  0000 C CNN
F 1 "10k" H 3925 4225 50  0000 C CNN
F 2 "AB-lib-foot:R_0603_AB" V 4005 4225 50  0001 C CNN
F 3 "~" H 4075 4225 50  0001 C CNN
	1    4075 4225
	1    0    0    -1  
$EndComp
$Comp
L Device:R R9
U 1 1 5EA83052
P 4075 4700
F 0 "R9" H 3925 4825 50  0000 C CNN
F 1 "4k7" H 3925 4700 50  0000 C CNN
F 2 "AB-lib-foot:R_0603_AB" V 4005 4700 50  0001 C CNN
F 3 "~" H 4075 4700 50  0001 C CNN
	1    4075 4700
	1    0    0    -1  
$EndComp
Wire Wire Line
	4075 4550 4075 4475
Connection ~ 4075 4475
Wire Wire Line
	4075 4475 4800 4475
Wire Wire Line
	4075 4375 4075 4475
$Comp
L AB_Library-sch:GND #PWR015
U 1 1 5EA87126
P 4075 4900
F 0 "#PWR015" H 4025 4950 50  0001 C CNN
F 1 "GND" H 4075 4850 50  0001 C CNN
F 2 "" H 4075 4900 50  0001 C CNN
F 3 "" H 4075 4900 50  0001 C CNN
	1    4075 4900
	1    0    0    -1  
$EndComp
$Comp
L AB_Library-sch:+12V #PWR014
U 1 1 5EA877DF
P 4075 4075
F 0 "#PWR014" H 4075 3925 50  0001 C CNN
F 1 "+12V" H 4091 4256 50  0000 C CNN
F 2 "" H 4075 4075 50  0001 C CNN
F 3 "" H 4075 4075 50  0001 C CNN
	1    4075 4075
	1    0    0    -1  
$EndComp
Text Notes 1425 875  0    50   ~ 0
Zo=sqrt(Lr/Cr) should be in a range of: 25 .. 180 ohm (ca).\nLr: preferably an air coil or with proper ferrite core.
$Bitmap
Pos 2925 5450
Scale 1.000000
Data
89 50 4E 47 0D 0A 1A 0A 00 00 00 0D 49 48 44 52 00 00 00 40 00 00 00 40 08 06 00 00 00 AA 69 71 
DE 00 00 00 04 73 42 49 54 08 08 08 08 7C 08 64 88 00 00 00 09 70 48 59 73 00 00 0E 74 00 00 0E 
74 01 6B 24 B3 D6 00 00 08 29 49 44 41 54 78 9C E5 9B 5F 4C 54 D9 1D C7 3F 73 87 61 76 81 71 E2 
CE 92 22 71 09 1D 31 8B 48 D3 89 31 A2 6D 04 22 D5 A4 66 FB 66 97 A0 8D 54 4A 8C FA 60 B3 BE 34 
FA 30 A1 B1 5A 5B 88 8B 0F BA 7D D0 87 2E 21 F5 4F 69 9A 9A 35 26 4D 1C 40 B4 69 34 A6 86 54 AC 
7F 56 47 A4 14 95 3F 8E 0E CA FC E1 D7 87 0B 96 1D EE 9D 3B 33 77 66 C4 F4 9B 9C 64 EE 39 F3 FB 
F7 3D F7 9E 7B CE B9 BF 63 21 B3 B0 00 15 C0 F7 81 72 60 D9 4C 71 02 F9 C0 22 60 1A 78 39 53 26 
80 FB 33 E5 5F C0 55 E0 16 20 19 F6 33 AD 78 0F D8 02 FC 11 78 86 EA BC 99 F2 6C 46 D7 A7 C0 FB 
59 8C 23 69 94 01 BF 43 ED 45 B3 41 EB 95 00 70 0A 58 91 A5 98 12 C2 C7 C0 69 20 42 E6 02 8F 2D 
51 E0 CF C0 77 B3 10 9F 2E DE 07 5A 80 D7 64 2F 70 2D 22 BE 04 5C A9 06 61 49 51 6E 0D 6A AF 7F 
3B 59 41 AB D5 4A 71 71 31 79 79 79 14 14 14 00 30 39 39 49 30 18 64 78 78 98 70 38 9C 8A 3F FF 
01 B6 03 7F 4D 56 30 59 02 2C C0 CF 81 DF 00 B9 89 08 78 3C 1E 6A 6A 6A A8 AE AE A6 B2 B2 92 D2 
D2 52 72 73 B5 45 23 91 08 7E BF 9F 5B B7 6E 71 F9 F2 65 7A 7A 7A B8 7E FD 3A D3 D3 D3 89 98 9A 
06 0E A3 DE 95 D1 44 04 92 45 0E F0 7B 12 B8 35 97 2E 5D 2A 2D 2D 2D 72 E7 CE 1D 31 0B BF DF 2F 
47 8E 1C 91 E5 CB 97 27 FA 58 5C 40 7D C5 A6 15 79 C0 79 23 E3 6E B7 5B 4E 9E 3C 29 53 53 53 A6 
03 8F 45 24 12 91 D3 A7 4F 4B 65 65 65 22 24 FC 0D 13 E3 42 2C DE 03 7C F1 0C DA ED 76 F1 7A BD 
F2 EA D5 AB B4 07 1E 8B 70 38 2C 47 8F 1E 95 45 8B 16 19 91 D0 0F 7C 60 36 78 2B F0 A7 78 86 CA 
CB CB A5 BF BF 3F E3 81 C7 C2 EF F7 CB DA B5 6B 8D 48 B8 8A 7A F7 A6 8C 2F E2 19 D8 B2 65 8B 04 
02 81 A4 9D 1F 18 18 10 AF D7 2B 0D 0D 0D D2 D0 D0 20 5E AF 57 6E DF BE 9D B4 9E 50 28 24 7B F7 
EE 35 22 E1 AB 99 8E 4C 1A 3F 8D A7 78 D7 AE 5D 12 8D 46 93 76 BA A3 A3 43 72 72 72 E6 E9 B3 D9 
6C D2 D9 D9 99 B4 3E 11 91 B6 B6 36 B1 58 2C F1 48 F8 65 B2 C1 57 A0 2E 4E 34 15 EE DB B7 2F 25 
47 C7 C6 C6 24 3F 3F 5F D7 D1 82 82 02 19 1F 1F 4F 49 F7 A9 53 A7 E2 91 10 05 7E 90 68 F0 39 C0 
3F F4 9C 6C 6C 6C 94 E9 E9 E9 94 9C 3C 77 EE 9C E1 08 DE D5 D5 95 92 6E 11 91 D6 D6 D6 78 BA FF 
8D BA FA 34 C4 67 7A 4A 36 6E DC 28 A1 50 28 65 07 DB DB DB 0D 09 68 6F 6F 4F 59 BF 88 18 8D 09 
9F 1B 05 5F 8C BA E2 9A 27 5C 5C 5C 2C 23 23 23 A6 9C 3B 7E FC B8 21 01 27 4E 9C 30 65 23 14 0A 
49 55 55 95 9E FE 30 F0 9D 78 04 1C D7 12 54 14 45 BA BB BB 4D 39 26 22 D2 DB DB 6B 48 40 5F 5F 
9F 69 3B 0F 1F 3E 14 87 C3 A1 67 A3 4B 2F F8 6F 01 AF B4 84 9A 9B 9B 4D 3B 25 22 12 8D 46 C5 E3 
F1 E8 06 BF 6A D5 AA 94 C7 97 58 B4 B5 B5 C5 1B 10 CB B5 08 F8 B5 96 80 CB E5 92 67 CF 9E A5 C5 
29 11 91 47 8F 1E C9 86 0D 1B E6 D9 A9 AB AB 93 C1 C1 C1 B4 D9 09 85 42 52 51 51 A1 47 C2 C9 D8 
E0 AD C0 B0 D6 9F 0F 1D 3A 94 36 A7 E6 62 70 70 50 7C 3E 9F F8 7C 3E 79 FC F8 71 46 6C 74 76 76 
EA 11 10 20 66 7B 6D 93 D6 1F 9D 4E A7 4C 4C 4C 64 C4 B9 6C 20 1C 0E 8B DB ED D6 23 E1 C7 00 CA 
0C 01 0D 5A CF 44 63 63 23 4E A7 53 AB 29 21 8C 8F 8F B3 69 D3 26 6C 36 1B 16 8B 25 A9 62 B3 D9 
D8 BC 79 33 81 40 20 65 FB 39 39 39 34 35 35 E9 35 7F 3A F7 62 10 0D 96 AE 5D BB 66 AA 07 BC 5E 
AF E1 A8 6F 54 5A 5A 5A 4C F9 70 FF FE 7D BD 19 E2 53 C0 A2 00 6E 60 69 2C 3D 65 65 65 AC 5E BD 
3A 45 EE 55 F8 FD 7E 53 F2 00 0F 1E 3C 30 25 EF 76 BB F1 78 3C 5A 4D 1F 02 2B 14 60 BD 56 6B 5D 
5D 9D 29 C3 0B 09 B5 B5 B5 7A 4D DF 53 D0 D9 63 AF A9 A9 C9 94 3F 59 C7 FA F5 9A 7D 0C F0 B1 02 
2C D7 6A D1 B9 6D DE 49 AC 5C B9 52 AF 69 99 82 FA AD EE 1B B0 5A AD B8 DD EE 8C 3A 95 4D 94 96 
96 62 B5 6A EE 89 2C 53 D0 D8 3C 5C B2 64 09 76 BB 3D E3 8E 65 0B B9 B9 B9 14 15 15 69 35 2D 56 
80 82 D8 DA 45 8B 12 5A 36 BF 53 70 38 1C 5A D5 F9 0A 1A 7B E8 F9 F9 69 DF 56 7F EB 98 FD 0A 15 
5B AD 68 D5 FE 3F 41 01 82 B1 95 C1 E0 BC AA 77 1E 2F 5F BE D4 AC 56 80 17 B1 B5 66 E6 DF 0B 15 
2F 5E CC 0B 13 20 A8 00 63 B1 B5 C3 C3 C3 4C 4D 4D 65 DC A9 6C 21 1C 0E 33 32 32 A2 D5 34 AE 00 
F7 62 6B A3 D1 A8 E9 39 F8 42 82 DF EF 27 12 89 68 35 7D 9D 83 06 01 00 37 6F DE A4 BC 5C 73 E7 
28 61 B4 B6 B6 E2 F5 7A DF 5C AF 58 B1 82 50 28 14 57 26 37 37 97 81 81 81 37 D7 3A AF AF A4 30 
57 5F 0C BE CE 41 CD C2 9A 87 EE EE 6E EA EB EB 4D 19 2E 2C 2C A4 B0 B0 F0 CD B5 C5 62 9C 8E 60 
B1 58 D2 3E 0B ED EB EB D3 6B BA A3 00 97 B5 5A 2E 5D BA 94 56 27 DE 26 7A 7B 7B F5 9A AE CE FE 
F0 A3 B1 19 71 E3 C6 0D 53 9B 11 B1 B0 DB ED 86 1B 20 76 BB 3D AD 36 87 86 86 C4 6A B5 6A D9 1A 
03 94 D9 89 90 66 6E 4D 47 47 87 19 E2 17 04 CE 9C 39 43 34 AA 99 31 D3 83 9A 56 03 C0 06 34 7A 
63 F1 E2 C5 F2 FC F9 F3 B4 F5 46 B6 EF 80 68 34 1A 6F 6B 7C EB 5C 36 14 74 F6 05 0F 1F 3E 9C 36 
87 B2 4D 40 57 57 97 9E 9D 20 1A 8B C0 16 AD 3F BB 5C 2E 79 FA F4 69 5A 1C CA 26 01 91 48 24 DE 
57 A8 2F B5 9E 89 0F 50 A7 C5 F3 04 76 EC D8 91 16 A7 B2 49 C0 B1 63 C7 F4 6C 4C 13 E7 03 69 9B 
96 90 C5 62 91 8B 17 2F 9A 76 2A 5B 04 F8 FD 7E 71 3A 9D 7A 36 FE A2 17 3C A8 5B C5 9A 19 DE 85 
85 85 A6 3F 61 65 83 80 D7 AF 5F CB 9A 35 6B F4 F4 87 49 20 BF F8 67 7A CE AD 5B B7 4E 26 27 27 
17 34 01 CD CD CD F1 F4 1F 33 0A 1E D4 74 D8 1E 3D 25 9F 7C F2 89 84 C3 E1 05 49 C0 FE FD FB E3 
E9 1E 42 3D A8 91 10 3E 42 FD 74 A4 A9 6C EB D6 AD 29 91 90 49 02 5A 5A 5A E2 E9 0D 03 35 89 06 
3F 8B 1F A2 26 13 E8 DE 09 C1 60 F0 AD 13 10 89 44 64 F7 EE DD 46 7A F7 EB 05 69 B4 3C FB 05 70 
44 AF B1 AA AA 8A B3 67 CF 52 52 52 62 C8 26 C0 B6 6D DB 0C D3 E1 6D 36 1B 9D 9D 9D 09 E9 1B 1D 
1D 65 FB F6 ED 5C B8 70 21 DE DF FE 00 FC 84 39 D3 DE 64 A1 F9 6A 9C 2D 2E 97 4B CE 9F 3F 9F 54 
AF A5 03 7D 7D 7D 52 52 52 62 D4 F3 17 00 5B AA 81 CF C2 82 9A 52 12 D7 58 7D 7D BD 0C 0D 0D 65 
3C F0 D1 D1 51 D9 B9 73 A7 28 8A 62 14 BC 0F 93 79 C2 B1 24 FC D6 88 04 87 C3 21 07 0E 1C 90 27 
4F 9E A4 3D F0 89 89 09 39 78 F0 A0 B8 5C 2E C3 71 04 38 0B 64 E4 D3 D6 67 24 70 38 2A 3F 3F 5F 
9A 9A 9A C4 E7 F3 A5 94 4F 3C 8B E9 E9 69 B9 72 E5 8A EC D9 B3 27 DE CC 2E B6 7C CE FF 32 5F 0C 
91 CA 99 A1 3A A0 13 35 AD CE 10 45 45 45 D4 D6 D6 52 5D 5D 8D C7 E3 A1 AC AC EC 1B DB 64 73 31 
36 36 C6 DD BB 77 E9 EF EF A7 A7 A7 07 9F CF C7 D0 D0 50 A2 7E 05 80 9D C0 99 44 05 20 F5 43 53 
45 A8 2B AA 8D A9 08 17 14 14 E0 70 38 C8 CB CB 43 51 14 26 27 27 09 04 02 7A 7B F7 89 E0 EF A8 
23 BD E6 06 6F 26 F1 23 74 F6 11 B2 54 C6 50 0F 71 A5 74 1E 20 5D 70 02 BF 22 B3 27 46 63 4B 00 
75 50 FE 30 0B F1 25 0C 27 70 00 78 40 E6 02 F7 03 5E D2 70 16 28 93 B0 A0 26 5E 7D 81 7A 0A DC 
6C D0 F7 66 74 AD 27 F5 31 2B AE B3 99 C6 47 A8 0B 91 0A D4 7C A4 32 60 31 EA E1 05 07 EA 14 35 
88 FA 08 8D A3 06 7C 0F F8 27 EA AA 34 E1 D7 40 2A F8 2F C6 13 9C 40 CD 3A 83 FA 00 00 00 00 49 
45 4E 44 AE 42 60 82 
EndData
$EndBitmap
$Bitmap
Pos 2175 5450
Scale 1.000000
Data
89 50 4E 47 0D 0A 1A 0A 00 00 00 0D 49 48 44 52 00 00 01 2F 00 00 00 48 08 02 00 00 00 28 3A E4 
D9 00 00 00 03 73 42 49 54 08 08 08 DB E1 4F E0 00 00 00 09 70 48 59 73 00 00 0E 74 00 00 0E 74 
01 6B 24 B3 D6 00 00 20 00 49 44 41 54 78 9C EC 7D 67 78 5C E5 99 F6 7B CA F4 AE 29 1A 35 CB 92 
AC 66 C9 96 7B AF B8 C8 05 63 07 83 4D 4B 48 08 21 04 92 5D 02 4B C2 02 5F B8 12 42 B2 24 B0 24 
C4 21 57 00 DB F4 62 27 B4 80 2B C6 05 57 D9 D8 B2 2C CB B2 7A 1F 8D 34 D2 F4 7E CA F7 E3 CE 79 
AF 59 B0 F9 E2 5D B2 EC 7E E1 FC E0 32 D2 E8 CC 39 EF FB 94 FB B9 9F F2 32 DB B7 6F 27 5F 5D FF 
90 57 2A 95 D2 E9 74 2A 95 2A 1C 0E CB B2 CC B2 AC 56 AB 15 45 51 10 04 59 96 D5 6A 75 3A 9D 36 
1A 8D 7E BF 9F E3 38 9E E7 D5 6A 35 7E 25 8A 22 CB B2 84 10 8F C7 73 CF 3D F7 5C F2 E6 0F 3E F8 
60 55 55 95 4E A7 93 65 99 10 92 48 24 38 8E E3 38 0E FF FB D5 75 C9 8B FF B2 1F E0 AB EB 4B BB 
38 8E 4B 26 93 92 24 71 1C 67 34 1A 79 9E 6F 6B 6B 33 18 0C 92 24 11 42 44 51 8C C7 E3 A2 28 A6 
D3 69 B3 D9 9C 4C 26 65 59 96 24 89 55 2E 42 08 C3 30 97 D3 2E 7C 46 96 65 41 10 A0 87 F8 DF FF 
D6 37 FC DF 76 7D A5 8D FF B8 97 56 AB 8D C5 62 92 24 A5 D3 E9 68 34 1A 0E 87 B7 6C D9 F2 C9 27 
9F E0 B7 6A B5 3A 95 4A 11 42 38 8E AB AC AC FC C9 4F 7E 22 49 12 B4 91 E3 38 AA 87 1C C7 5D EE 
FE 0C C3 10 42 44 51 64 18 06 DA 98 4E A7 A1 C6 5F 5D 97 BC BE D2 C6 7F D0 2B 95 4A F1 3C 4F 08 
D1 68 34 3C CF 33 0C A3 D7 EB BB BB BB 55 2A 95 2C CB 0C C3 68 34 1A 41 10 08 21 5A AD 36 3B 3B 
9B 10 22 CB 32 75 6E F0 93 40 AD 97 BC 7F 3A 9D C6 7D F0 61 86 61 F0 EF AF AE CF B9 BE D2 C6 7F 
D0 4B A3 D1 30 0C 23 29 97 2C CB 56 AB 35 2B 2B 6B 64 64 04 2A 07 60 29 CB 72 22 91 90 24 89 EA 
15 C9 50 45 7C EC 92 F7 C7 07 18 86 61 59 16 5F 84 7F FC 37 BE E2 FF BE EB 2B 6D FC 07 BD A0 6C 
2A 95 4A 92 24 51 14 A3 D1 A8 28 8A A9 54 0A FA 03 8F A7 52 A9 D2 E9 34 D4 15 7F 05 17 27 8A 22 
F4 53 A5 52 5D EE FE 7A BD 9E 65 59 7C 8C 65 59 41 10 10 A0 D2 5B 7D 75 7D F6 FA 4A 1B FF 41 AF 
78 3C 0E 9A 94 10 62 32 99 10 FE E9 74 3A 49 92 D4 6A B5 28 8A 88 F7 E0 D6 E0 24 A1 57 D0 31 42 
08 CF F3 3A 9D EE C6 1B 6F BC E4 FD 1D 0E 07 58 59 59 96 39 8E 13 45 11 B4 ED 7F E7 3B FE AF BB 
BE D2 C6 7F D0 0B 8A 27 CB 72 30 18 34 99 4C E0 72 E0 12 A1 33 48 63 50 57 06 5C 4A C3 3F 86 61 
78 9E D7 68 34 6B D7 AE BD E4 FD D3 E9 B4 4A A5 4A 24 12 B8 E1 57 18 F5 6F B9 2E AB 8D 34 A8 00 
21 06 8C 01 7B 09 23 87 AD C2 4F 78 9E 57 A9 54 A3 A3 A3 C3 C3 C3 C1 60 30 14 0A F9 FD FE 48 24 
92 4E A7 D5 6A B5 46 A3 31 18 0C 59 59 59 39 39 39 4E A7 13 F4 00 C3 30 6A B5 5A 96 E5 78 3C 4E 
08 D1 6A B5 0C C3 24 12 09 E4 B8 D4 6A 75 32 99 4C A7 D3 5A AD 56 96 E5 48 24 A2 D3 E9 2E FD 02 
3C 3F 32 32 92 9D 9D 2D 49 52 30 18 34 18 0C 78 60 D8 72 41 10 C0 E3 A9 D5 6A 49 92 92 C9 A4 4E 
A7 8B C5 62 90 15 B5 5A 8D D7 84 90 25 12 09 A4 D4 2C 16 4B 30 18 C4 2B 6B B5 DA 78 3C AE D7 EB 
23 91 08 D2 71 94 9C 10 45 51 AB D5 FA 7C 3E A7 D3 99 4A A5 44 51 54 AB D5 2C CB 22 6D 60 32 99 
C2 E1 30 12 06 91 48 84 E3 38 9D 4E 87 6F 21 84 A8 54 2A 41 10 A2 D1 A8 D1 68 A4 4B 8D B4 9E 28 
8A C9 64 12 9F 87 6F D1 6A B5 58 19 BD 5E AF D1 68 46 47 47 91 06 B4 DB ED C9 64 32 1C 0E BB DD 
EE 48 24 42 08 C1 BA 05 02 01 BD 5E 6F B5 5A 81 3C 63 B1 98 46 A3 51 AB D5 D1 68 14 4B 2D 49 52 
2A 95 E2 38 2E 91 48 18 8D 46 8D 46 93 48 24 34 1A 0D 55 39 6C AE 4A A5 A2 24 0D 1E 38 16 8B 81 
6B E5 38 2E 9D 4E 83 FE B9 E4 BE B0 2C 8B 6F 37 1A 8D 91 48 44 A5 52 31 0C 83 3F D4 E9 74 A1 50 
88 E7 79 9E E7 93 C9 24 21 44 A3 D1 A4 D3 69 8E E3 F0 27 40 C8 1A 8D 86 AE 49 2C 16 13 04 01 42 
02 FE 89 FA 67 24 51 C0 48 45 A3 51 9D 4E A7 56 AB 43 A1 90 24 49 56 AB 35 99 4C C6 62 31 8B C5 
82 8D C3 AF 6C 36 5B 28 14 12 04 C1 6C 36 A7 D3 E9 FF B4 F2 7C E1 D7 65 B5 11 74 99 4A A5 C2 56 
8D 8E 8E AA D5 6A BB DD 0E C1 82 64 F3 3C 9F 4A A5 5A 5A 5A CE 9F 3F 7F F2 E4 C9 50 28 14 0E 87 
33 03 03 28 2A AC 2C B6 87 E7 F9 E2 E2 E2 F2 F2 F2 92 92 92 B1 63 C7 16 15 15 39 9D CE 48 24 02 
E0 64 34 1A 21 DF 91 48 C4 60 30 F0 3C 8F 6D CB CA CA 82 D2 7E F6 4A 26 93 6E B7 7B 78 78 D8 62 
B1 58 2C 96 68 34 6A B1 58 3C 1E 8F CD 66 8B C5 62 20 D6 DB DB DB 3F FE F8 E3 0B 17 2E C4 E3 F1 
C1 C1 41 42 88 4A A5 D2 E9 74 59 59 59 25 25 25 53 A6 4C A9 A8 A8 D0 EB F5 4E A7 73 64 64 44 A3 
D1 8C 8C 8C 00 C2 A9 54 AA E6 E6 66 AF D7 CB 71 5C 2C 16 33 18 0C 48 7F 13 42 72 72 72 2A 2A 2A 
24 49 CA CB CB 0B 06 83 82 20 A4 52 A9 A6 A6 26 51 14 67 CC 98 01 71 B7 5A AD 43 43 43 B2 2C 17 
14 14 88 A2 78 E1 C2 85 FA FA FA F6 F6 F6 BE BE BE E1 E1 E1 44 22 01 71 D4 6A B5 05 05 05 93 27 
4F AE A9 A9 C9 CF CF D7 EB F5 F8 A2 E1 E1 E1 31 63 C6 78 BD DE 44 22 A1 D7 EB 6D 36 1B 6C 9C C5 
62 89 C7 E3 B9 B9 B9 3D 3D 3D 06 83 A1 B3 B3 F3 B9 E7 9E 1B 18 18 48 A7 D3 03 03 03 84 10 AB D5 
8A A4 85 CD 66 1B 33 66 8C C5 62 A9 AC AC AC AA AA 72 3A 9D 30 40 D0 37 9E E7 4D 26 D3 C0 C0 00 
56 09 4A 4B 08 49 A7 D3 99 0E 90 65 D9 44 22 11 8F C7 D5 6A B5 D1 68 84 60 98 4C A6 74 3A 9D 4E 
A7 1B 1A 1A 2E B9 2F E5 E5 E5 6A B5 FA C0 81 03 7A BD 3E 1E 8F 9B CD 66 41 10 20 09 B0 E6 F3 E7 
CF 87 0A C1 A6 D3 F2 03 7C F5 B1 63 C7 A8 19 4D 26 93 2C CB 6A 34 9A 58 2C A6 D7 EB 6B 6A 6A A0 
8D 48 87 C2 A6 F7 F5 F5 35 36 36 9E 3B 77 AE A7 A7 47 96 E5 D1 D1 51 FC 55 56 56 56 71 71 71 55 
55 D5 84 09 13 0A 0A 0A 12 89 84 C5 62 19 18 18 18 3B 76 AC 20 08 7E BF 1F 1B FD 3F E4 62 2E 57 
8B 03 AB 93 4A A5 04 41 D0 68 34 7A BD 3E 95 4A 41 37 CC 66 73 22 91 38 7B F6 EC B1 63 C7 2E 5E 
BC 38 34 34 94 4A A5 B4 5A 2D 22 7E 9A E7 85 5A 22 CB 44 08 A1 D6 91 28 86 D6 64 32 55 57 57 2F 
5A B4 A8 A6 A6 06 F7 17 04 21 1C 0E E7 E7 E7 C3 C0 23 25 1D 8B C5 40 BB 5F FA 05 14 AE 4F 10 04 
88 5A 3C 1E D7 6A B5 84 10 41 10 EA EA EA B6 6F DF DE D3 D3 03 17 1D 0E 87 41 3C E0 F1 F0 84 6A 
B5 5A A7 D3 2D 58 B0 60 E1 C2 85 39 39 39 E0 15 D5 6A 35 9C C0 2F 7E F1 8B 0B 17 2E E0 D5 74 3A 
5D 2A 95 C2 93 E4 E7 E7 6F DA B4 69 70 70 30 99 4C 7E FC F1 C7 C7 8E 1D EB ED ED 55 A9 54 93 27 
4F FE E1 0F 7F C8 30 8C 4E A7 1B 1D 1D CD CD CD 0D 04 02 DD DD DD EF BE FB 6E 77 77 B7 C7 E3 81 
2B C6 57 C3 27 C0 D9 E2 27 05 05 05 2B 57 AE 5C BA 74 A9 C5 62 19 19 19 C1 8B C8 B2 1C 8D 46 4D 
26 53 2A 95 82 BF C2 5A ED DB B7 6F DB B6 6D 44 D1 1F E4 D9 B1 11 58 67 00 19 9D 4E 07 17 37 75 
EA D4 95 2B 57 96 96 96 C2 65 25 93 C9 54 2A F5 6F FF F6 6F 81 40 40 A5 52 99 4C A6 FA FA 7A FC 
09 C7 71 82 20 00 B2 4A 92 94 9D 9D AD D7 EB E1 2D D5 6A 75 59 59 D9 B5 D7 5E 4B 08 19 19 19 F9 
E1 0F 7F 78 C9 7D 79 E8 A1 87 4A 4A 4A 1E 7F FC F1 FE FE FE 68 34 0A A5 82 DF 4B A5 52 66 B3 F9 
5F FF F5 5F 0B 0B 0B 01 91 90 4A 01 D9 23 8A 62 47 47 C7 AF 7E F5 AB 48 24 02 73 00 B7 09 50 B3 
78 F1 E2 5B 6F BD 55 AD 56 23 D0 15 45 B1 B3 B3 73 EF DE BD 27 4E 9C 88 46 A3 99 71 29 5E 24 D3 
37 4C 9F 3E FD EA AB AF AE A8 A8 60 18 26 12 89 98 4C 26 83 C1 00 BC F0 3F E4 BA AC 6F 04 6F 06 
73 05 69 50 A9 54 4E A7 93 10 72 F0 E0 C1 5D BB 76 B5 B6 B6 C6 62 31 7C 98 46 08 94 D1 CE CC 47 
69 B5 5A E0 37 38 5B 2C 3A 7E 75 F2 E4 C9 A3 47 8F 66 67 67 5F 73 CD 35 73 E6 CC 31 9B CD 79 79 
79 03 03 03 16 8B 25 27 27 67 68 68 88 E7 79 AB D5 0A CF 7C C9 E7 54 A9 54 81 40 C0 E9 74 46 A3 
51 40 4A 59 96 F5 7A FD B9 73 E7 5E 7F FD F5 33 67 CE 70 1C 67 B7 DB 47 47 47 53 A9 54 56 56 96 
DF EF A7 78 0C F7 4C A5 52 A9 54 6A DF BE 7D 07 0E 1C B8 FD F6 DB 67 CF 9E 0D 73 6B 34 1A BB BB 
BB F5 7A 3D 96 82 28 56 9C FE 6D 2C 16 DB B5 6B D7 FE FD FB FD 7E 3F DE 11 76 07 F8 0D B6 79 68 
68 E8 EC D9 B3 2F BC F0 82 CF E7 C3 03 B3 2C 8B 45 48 A5 52 C0 69 F4 27 C9 64 B2 B7 B7 77 FB F6 
ED 07 0F 1E FC DE F7 BE 57 55 55 D5 DB DB 6B B7 DB 75 3A 1D E0 03 F2 F5 3A 9D 2E 1A 8D FE E8 47 
3F 0A 04 02 00 D5 84 10 BD 5E 0F DE 32 99 4C 0A 82 A0 52 A9 F4 7A 3D F0 36 90 33 21 E4 D8 B1 63 
2D 2D 2D CB 97 2F BF E9 A6 9B 86 87 87 59 96 B5 5A AD 1E 8F 67 68 68 08 2B 09 08 03 DD A6 18 9E 
10 E2 F5 7A 6D 36 5B 38 1C 86 13 B3 5A AD 36 9B 4D 14 C5 D1 D1 51 F8 B7 CF 5E 82 20 B8 5C AE 49 
93 26 5D BC 78 11 AB 41 08 D1 68 34 58 C0 50 28 E4 F1 78 26 4E 9C 08 53 8B E0 02 9E 53 A7 D3 1D 
3A 74 08 C0 1B 42 02 C8 8A 9F 4C 9A 34 09 40 89 61 18 BF DF 7F EA D4 A9 0F 3E F8 A0 AF AF 8F 10 
82 D0 00 A8 9E 8A 22 E0 77 2A 95 52 AB D5 9F 7C F2 C9 C9 93 27 97 2D 5B F6 FD EF 7F 9F 65 59 83 
C1 D0 DF DF 6F B1 58 AE 44 5F FE BE 17 B7 61 C3 86 4B FE 22 95 4A E9 F5 7A EC 25 2C 93 DF EF 6F 
6C 6C FC E9 4F 7F BA 7F FF FE FE FE 7E E8 2A 24 1B E2 8B FF 05 1D 07 FB 0A 43 8E 0D C6 36 D0 8F 
01 BB 13 42 B2 B2 B2 22 91 C8 89 13 27 EA EB EB 93 C9 64 76 76 B6 C9 64 82 93 84 09 CC 0C 69 3E 
7B 21 AC 82 A9 83 9E AB 54 AA FD FB F7 3F FA E8 A3 3E 9F CF 60 30 E8 F5 7A 04 5D 84 10 84 3A B4 
94 04 8F 4A 94 20 27 95 4A 35 37 37 B7 B5 B5 2D 59 B2 C4 68 34 9E 3E 7D BA AC AC EC C8 91 23 BD 
BD BD 30 EA B0 D3 C0 78 06 83 E1 F5 D7 5F 6F 68 68 30 1A 8D A0 40 F0 84 65 65 65 53 A7 4E E5 79 
3E 1A 8D BA DD EE AD 5B B7 7E F0 C1 07 3E 9F 4F A7 D3 69 B5 5A 40 AC 74 3A 0D CF 83 92 34 C0 5A 
58 28 8D 46 93 4A A5 86 87 87 87 86 86 9C 4E 67 41 41 41 28 14 82 44 82 A2 54 AB D5 5E AF F7 BE 
FB EE C3 93 C4 62 31 AB D5 8A AF B3 5A AD B2 2C A7 D3 69 9D 4E 97 4C 26 93 C9 24 30 08 44 1C B1 
53 38 1C F6 F9 7C 2C CB CE 9A 35 0B 28 74 DB B6 6D 50 15 B8 3E 98 51 18 14 84 CD F8 15 B2 8E 08 
C8 B3 B3 B3 E7 CE 9D 0B 06 68 C7 8E 1D D2 A5 AE 39 73 E6 8C 1D 3B D6 68 34 EE DE BD 1B 01 30 C8 
05 AA 78 1C C7 CD 99 33 27 1C 0E A7 D3 69 58 90 78 3C 0E 80 F3 EA AB AF 0E 0E 0E 62 65 44 51 44 
68 9D 4E A7 9D 4E E7 2D B7 DC 82 62 3D 96 65 9F 7F FE F9 B7 DE 7A 0B 2B 80 9B 58 AD 56 28 2D F5 
EA 80 B2 08 B2 10 31 B6 B6 B6 36 34 34 2C 5A B4 08 78 15 EF FE 3F E4 BA AC 36 D2 54 12 5E C6 E3 
F1 EC DC B9 F3 D5 57 5F C5 92 C1 EF 41 DF 88 52 78 01 F1 22 0A FF 86 B5 80 04 C3 5F C1 71 01 EC 
21 0E C4 3F 20 31 91 48 E4 EC D9 B3 6D 6D 6D 6E B7 DB E9 74 C2 3B 41 E0 3E A7 FC 8A E7 79 70 42 
C8 9E F1 3C 7F FC F8 F1 2D 5B B6 D0 CC 75 3C 1E 07 D4 A1 11 3F D5 40 95 4A 05 87 20 CB B2 C1 60 
48 A5 52 89 44 C2 EF F7 F7 F7 F7 4F 9C 38 31 2B 2B 2B 91 48 7C FC F1 C7 BD BD BD 94 13 C2 6D 61 
AA 53 A9 94 C9 64 C2 3F 70 1F 49 92 EC 76 FB 8C 19 33 90 3C D8 B9 73 E7 8E 1D 3B 46 46 46 DC 6E 
77 20 10 48 A5 52 10 23 9A 43 87 D3 63 59 D6 68 34 12 42 44 E5 62 59 76 70 70 B0 BB BB 7B D9 B2 
65 B2 2C 03 E3 51 21 DE B4 69 D3 C8 C8 08 EE A6 52 A9 40 4A 71 1C 87 38 8A E6 2D 50 5E 83 BF 4D 
A5 52 B1 58 0C F8 39 16 8B 9D 3C 79 72 FA F4 E9 80 A3 7B F7 EE 05 0E 87 1B C4 5B D0 D4 3F 9E 8A 
E3 38 94 EC 60 97 0B 0B 0B A7 4D 9B C6 71 9C DF EF FF F0 C3 0F D9 4B 5D CB 96 2D 73 B9 5C 46 A3 
F1 F8 F1 E3 70 AA D4 0C 41 66 62 B1 D8 EA D5 AB 75 3A 1D E2 20 8D 46 43 2D CE 8B 2F BE 08 62 06 
AA 02 5A 8B 10 32 73 E6 CC A5 4B 97 12 42 F4 7A FD E3 8F 3F DE DD DD 9D 48 24 A0 C6 70 FE F0 8A 
1A 8D 86 FA 79 08 67 3A 9D 0E 87 C3 08 FE D5 6A 75 7F 7F FF F0 F0 70 6D 6D 2D 0A E2 BF 08 3D FA 
62 AE CB 22 55 8E E3 40 51 EA 74 BA 53 A7 4E BD F8 E2 8B AD AD AD 10 08 A2 44 6B 82 20 20 56 31 
18 0C B1 58 CC E9 74 8E 1D 3B B6 A0 A0 00 DC A9 D9 6C 56 A9 54 60 38 E2 F1 F8 D0 D0 50 5B 5B 5B 
7B 7B 3B B0 22 D8 45 59 96 69 80 0A D3 DB D0 D0 70 FE FC F9 6F 7E F3 9B EB D7 AF F7 FB FD B0 88 
81 40 E0 73 A2 6D 68 45 34 1A 15 04 A1 AB AB 6B DB B6 6D 7E BF 9F 10 02 0F 46 6F 4E 0B 26 61 F5 
A9 63 84 BD 8F 44 22 A0 28 A2 D1 E8 87 1F 7E 58 5E 5E 5E 5B 5B 1B 89 44 10 8B 42 99 F1 57 08 CC 
B0 D3 D1 68 54 92 24 64 BA 41 BA 22 00 63 18 A6 B1 B1 F1 D9 67 9F 45 44 14 0C 06 A1 DB 78 12 48 
3C BE 0B 7E 2C 14 0A 61 19 B1 2C 70 11 17 2F 5E 7C E7 9D 77 90 42 00 69 A1 D1 68 BA BA BA 4E 9E 
3C 09 A7 07 F2 39 16 8B E1 B6 0E 87 63 EE DC B9 93 26 4D D2 EB F5 84 90 8B 17 2F EE DD BB 97 10 
12 0A 85 58 96 B5 D9 6C E9 74 1A 78 84 10 E2 F1 78 F2 F2 F2 A2 D1 28 A8 38 42 88 D9 6C C6 63 10 
05 22 62 8B 09 21 60 F2 20 F1 5A AD 96 72 B0 A0 E8 2E B9 29 B1 58 2C 16 8B C9 B2 BC 60 C1 82 D7 
5E 7B 0D 68 13 B7 85 9F F4 F9 7C 1D 1D 1D 85 85 85 92 52 A4 0E 49 68 6B 6B 0B 06 83 F8 0A 8E E3 
10 29 40 87 27 4D 9A 94 48 24 44 51 3C 72 E4 48 5D 5D 1D FC 01 62 6F 94 F2 31 0C 13 8D 46 61 7D 
60 44 60 56 34 1A 0D E0 0F 0C 10 21 64 FF FE FD 53 A7 4E 9D 3E 7D FA 15 EA CB DF F7 BA AC 36 86 
42 21 97 CB 15 0C 06 B7 6F DF BE 73 E7 CE 81 81 01 04 4B 58 4D B5 5A AD 52 A9 A2 D1 A8 2C CB A5 
A5 A5 D3 A6 4D 9B 3F 7F BE D1 68 44 1E 02 48 15 88 C5 ED 76 53 A4 7A F5 D5 57 33 0C D3 DF DF DF 
DE DE BE 6F DF BE AE AE AE 40 20 00 2C 81 2F A5 C6 78 EB D6 AD AD AD AD B7 DC 72 0B A0 1A 48 F9 
4B 3E 67 24 12 B1 DB ED E0 54 C3 E1 F0 9F FE F4 A7 CE CE 4E 1A E4 7C 2A 46 67 59 76 D1 A2 45 2E 
97 4B A7 D3 0D 0E 0E 36 35 35 F5 F7 F7 C3 0C AB D5 6A 80 1C 9D 4E 17 8F C7 FF F4 A7 3F 4D 98 30 
01 41 05 3C 2A AD 05 A3 92 0A 27 46 19 7C 42 08 62 63 C4 69 5B B7 6E 25 4A 84 19 8F C7 11 EA E0 
0E 55 55 55 4B 97 2E 2D 2F 2F E7 38 CE E7 F3 D5 D5 D5 1D 3B 76 6C 68 68 88 3E 2D AC 9E 56 AB DD 
BA 75 EB FC F9 F3 81 33 61 6E 0E 1D 3A 84 04 00 FC 2A 70 38 40 DD 77 BF FB DD AB AE BA CA EF F7 
47 A3 51 B3 D9 5C 5E 5E BE 74 E9 D2 07 1F 7C 50 92 A4 58 2C 36 32 32 42 08 A1 6C D6 FE FD FB C7 
8D 1B 97 93 93 B3 6E DD 3A 10 75 91 48 64 D7 AE 5D 88 21 69 AE 1F AF 60 B7 DB 57 AD 5A A5 D3 E9 
90 B3 B1 58 2C B4 F7 EA 72 19 0E 95 4A 65 B5 5A 43 A1 D0 E2 C5 8B 5F 79 E5 15 B8 5F A2 D4 F7 40 
49 06 06 06 8A 8A 8A 10 A3 22 FD 80 C8 99 2E 32 12 4B F0 72 46 A3 71 E2 C4 89 40 28 AF BC F2 0A 
2D 18 A2 77 C6 E2 CF 98 31 63 DE BC 79 65 65 65 B2 2C 0F 0E 0E 1E 39 72 E4 C4 89 13 E1 70 98 3E 
18 E0 B7 24 49 5B B6 6C 99 38 71 E2 E5 32 67 5F CA C5 F3 3C 8F 67 75 B9 5C C3 C3 C3 06 83 81 10 
82 CC 5B 38 1C DE B3 67 CF 96 2D 5B C0 E5 C0 B4 C3 86 C1 9A CE 9B 37 6F CD 9A 35 A5 A5 A5 94 13 
A7 96 92 66 29 33 5D 10 82 37 A7 D3 E9 74 3A E7 CD 9B 37 3A 3A BA 7B F7 EE DD BB 77 07 83 41 B8 
0B 84 2E E9 74 DA 60 30 40 40 EF BB EF BE AC AC 2C 20 31 49 69 20 80 71 05 DD 6A 32 99 86 86 86 
1C 0E 07 68 DE 53 A7 4E 11 42 42 A1 10 8D 33 69 2F C2 86 0D 1B 96 2E 5D 0A 26 0D D6 97 61 98 6D 
DB B6 81 55 46 2A 32 99 4C C6 E3 F1 E2 E2 E2 95 2B 57 22 D3 80 FB 50 3C 8C 4F C2 BB 66 65 65 8D 
8E 8E C2 25 C2 57 A0 ED 88 61 98 BE BE 3E 50 ED F8 3C DE 0E D2 76 E7 9D 77 CE 9F 3F DF 6A B5 86 
C3 61 9E E7 2D 16 4B 49 49 C9 35 D7 5C F3 D4 53 4F 35 36 36 52 AA 10 05 68 2C CB 6E DA B4 E9 17 
BF F8 05 08 33 84 0C 90 66 95 4A 15 8F C7 71 F3 48 24 B2 68 D1 A2 EA EA EA 58 2C 86 40 0B 7C 06 
C7 71 AB 56 AD 7A E6 99 67 E0 40 08 21 E0 33 08 21 5E AF D7 64 32 C5 E3 F1 85 0B 17 22 50 94 24 
E9 E0 C1 83 D4 53 11 C5 5F 09 82 50 54 54 74 D5 55 57 D1 28 14 EF 08 D7 74 39 C1 02 61 0B C9 A9 
AE AE 6E 6A 6A 22 84 20 2A A6 58 FD DC B9 73 D3 A6 4D 33 1A 8D 88 56 10 6B 9C 38 71 82 28 E0 0B 
46 27 16 8B B9 5C AE CA CA 4A A4 49 4E 9D 3A 35 3C 3C 8C 9F 83 17 94 24 09 EC E8 83 0F 3E 38 7D 
FA 74 24 42 64 59 36 9B CD 53 A7 4E 05 48 01 AF 0E B4 9C 48 24 40 02 7D FC F1 C7 AB 56 AD 02 47 
2D 49 12 5C 28 B8 92 2F A5 6C 88 4D 24 12 06 83 01 EE 05 64 49 38 1C D6 EB F5 2A 95 EA 2F 7F F9 
CB 96 2D 5B B2 B2 B2 10 80 61 35 09 21 82 20 D4 D4 D4 3C F2 C8 23 3F FE F1 8F 0B 0B 0B 41 DC 5D 
E9 17 23 CB FF F5 AF 7F FD 37 BF F9 CD C6 8D 1B CD 66 33 FD 39 12 EE E9 74 BA BD BD FD F1 C7 1F 
F7 78 3C 08 3E CD 66 33 82 34 D4 0F 20 C7 4D 08 D1 6A B5 20 03 F6 EF DF 4F 9F 04 12 06 7C A2 52 
A9 D6 AC 59 B3 74 E9 D2 AC AC 2C F8 40 10 54 2C CB 6E DC B8 F1 BB DF FD 2E 84 2C 1E 8F BB DD EE 
BB EE BA EB 97 BF FC E5 8A 15 2B 00 B3 2F F7 FC 48 60 10 42 0A 0A 0A 6A 6A 6A AE BD F6 DA 7B EE 
B9 E7 37 BF F9 CD ED B7 DF 6E B5 5A DF 7F FF 7D 28 2D DD 54 93 C9 94 4C 26 D7 AE 5D 3B 6F DE 3C 
04 30 50 7E 00 54 9E E7 EF BC F3 4E 8B C5 02 FA 04 6F 01 FD F1 7A BD C8 25 52 98 67 B5 5A E1 12 
C1 19 6A B5 5A C4 08 80 BE 50 21 C4 63 0C C3 D8 6C 36 D8 2F 0A 2E 68 09 07 C9 A8 B0 21 19 75 36 
5F C8 05 03 04 A3 39 75 EA 54 EA BE 68 19 09 21 A4 BB BB 9B 10 82 0D 45 99 44 32 99 F4 7A BD 44 
31 07 08 22 38 8E 1B 1A 1A 5A B0 60 01 6A 39 0E 1C 38 20 CB 72 2C 16 C3 FE 82 E2 8A C7 E3 77 DE 
79 E7 F8 F1 E3 09 21 F8 39 64 80 61 98 CA CA CA DB 6E BB 0D 16 13 50 85 61 18 64 0A F6 EC D9 83 
FB 00 EB D1 10 E6 72 40 EC EF 7D F1 58 1D 1A FE 21 CB 27 49 D2 FB EF BF BF 7D FB 76 8E E3 46 47 
47 0D 06 03 02 65 64 C0 EF B8 E3 8E D5 AB 57 27 12 89 E1 E1 61 A3 D1 88 EC C2 95 6E 24 D0 7C 22 
91 30 99 4C 37 DC 70 C3 F8 F1 E3 DF 7B EF BD FA FA 7A A0 5C 41 10 AC 56 6B 20 10 E8 EA EA 7A EA 
A9 A7 1E 7A E8 A1 FC FC FC DE DE DE FC FC 7C AF D7 0B 5E 14 78 03 0E 53 14 45 AF D7 7B EA D4 29 
D0 BF 14 16 E2 A9 B2 B3 B3 97 2D 5B 56 51 51 E1 F1 78 F4 7A 7D 20 10 D0 E9 74 08 8C 0B 0A 0A 96 
2C 59 72 F1 E2 C5 96 96 96 AB AF BE 7A F1 E2 C5 10 74 78 18 D8 A0 4B 5E B1 58 CC 6E B7 7F ED 6B 
5F 9B 3B 77 AE 5E AF 47 30 09 E2 24 18 0C 1E 3D 7A 14 1F A3 60 01 A9 CE 6B AE B9 26 2F 2F 6F 78 
78 18 8F 0D A2 02 90 2C 2F 2F AF B6 B6 76 DB B6 6D 90 1B EA 40 80 A8 69 84 F3 83 1F FC C0 64 32 
C1 C9 C0 D8 23 E2 4D 24 12 76 BB DD E7 F3 D1 CA 1E 51 14 E3 F1 38 6E 05 C5 86 86 50 D2 0B CF 80 
DB 52 85 BC A2 4D FC 9C 8B 66 2C 08 21 B3 66 CD 7A F5 D5 57 69 82 97 5E 3D 3D 3D E1 70 18 5C 1D 
F8 F0 81 81 01 40 65 CA C0 27 12 09 64 8F 26 4C 98 40 08 09 06 83 0D 0D 0D F0 D8 C0 68 D0 61 8B 
C5 B2 7C F9 72 EC 0B FD 73 84 91 3A 9D AE BA BA 7A D6 AC 59 1F 7D F4 11 E4 1C 04 95 C1 60 E8 EE 
EE EE EB EB 2B 2B 2B A3 D1 32 96 E5 0B 5C 87 2B BA 58 5A 52 44 31 BA C9 64 DA B7 6F DF D6 AD 5B 
C1 89 23 4D 0C 92 A0 A2 A2 E2 D9 67 9F AD AE AE EE EB EB 4B 24 12 56 AB 15 3E EA 3F F1 F4 1A 8D 
26 10 08 E0 E5 63 B1 D8 82 05 0B EE BF FF FE 35 6B D6 D0 DA 8B 70 38 6C B3 D9 04 41 E8 ED ED 7D 
F2 C9 27 7B 7A 7A 90 C5 A6 95 59 F0 2D A0 E9 4C 26 53 73 73 33 21 84 46 A1 C8 29 63 FB A7 4D 9B 
E6 76 BB 91 90 4C 26 93 40 E3 50 FB BE BE 3E 49 92 BE FE F5 AF FF EA 57 BF AA AD AD C5 3D 61 0E 
10 EC 5D EE F9 6D 36 DB 86 0D 1B 16 2F 5E EC 70 38 68 E6 30 95 4A 0D 0E 0E 36 37 37 C3 DE 53 73 
40 1F 23 3B 3B DB E3 F1 20 5F 12 0A 85 34 1A 8D D1 68 04 B5 EB F5 7A E7 CF 9F 4F 3F 0C 39 86 3F 
3C 77 EE 1C 50 09 8A 4B 58 96 0D 04 02 81 40 00 8F 07 00 A9 56 AB 03 81 00 AA E7 40 44 7B 3C 9E 
8E 8E 8E B3 67 CF 42 15 81 05 70 7F 5C 94 35 65 94 EB 4A 37 F1 73 2E CA 67 4A 92 04 9C 89 30 04 
5A 84 28 26 91 48 74 74 74 E0 69 61 35 CE 9D 3B 47 C1 30 0A E5 08 21 89 44 62 E1 C2 85 A0 73 DB 
DA DA E0 DB 59 96 05 B1 84 C0 6F DE BC 79 44 C1 E1 34 1F 06 56 2C 12 89 24 93 C9 8A 8A 0A 70 4E 
94 7D 05 9F D7 D4 D4 84 FB 64 96 0A 7C 59 44 2B 0F 68 8E 77 8B 46 A3 B9 B9 B9 75 75 75 88 92 11 
5A 80 38 35 1A 8D 63 C6 8C F9 FE F7 BF 8F 3A 35 80 1F B8 7E A4 D1 B0 70 7F FB 15 89 44 1C 0E 07 
32 1C A8 86 93 24 E9 E6 9B 6F 2E 2D 2D FD F5 AF 7F AD 52 A9 50 8E 83 D8 AC B9 B9 79 F3 E6 CD 3F 
FF F9 CF 3B 3A 3A F0 57 92 24 81 51 C0 B2 CA B2 DC DC DC AC D7 EB B1 AF 08 BA 88 62 A1 67 CD 9A 
C5 B2 6C 28 14 42 C5 8F C9 64 12 45 11 10 9D 10 02 0C 8C 94 3A DC 14 B8 47 9E E7 1D 0E C7 E5 9E 
5F 10 84 E9 D3 A7 1B 0C 06 44 71 D4 53 19 8D C6 D6 D6 56 A2 A0 32 A0 6E DA C4 B0 7D FB F6 50 28 
64 36 9B 11 B7 D8 ED 76 38 10 14 57 C4 62 31 10 9B 34 CE 44 DD E6 C5 8B 17 69 2F 12 14 C9 6C 36 
03 59 D0 72 53 51 14 5B 5B 5B 9B 9B 9B 3D 1E 4F 57 57 D7 E0 E0 20 56 C9 6E B7 13 42 68 C8 44 32 
AA 97 F0 22 7F 27 3F 80 F7 02 17 9A 4E A7 E7 CF 9F 7F EE DC 39 49 29 7E C2 1E 31 0C 53 5F 5F 3F 
67 CE 1C 30 BD 1A 8D A6 BE BE 1E 49 0E 42 88 56 AB 05 E5 2B 08 C2 8A 15 2B 90 00 3F 77 EE 1C 64 
8F B2 12 D0 9C 44 22 F1 D6 5B 6F 11 C5 E8 20 D2 A1 25 19 C8 18 51 D3 03 F4 01 CE AC A5 A5 65 E9 
D2 A5 80 A9 44 69 34 A3 B9 83 FF E6 8B E7 79 1E 3C 04 EC EE F0 F0 F0 E6 CD 9B 83 C1 20 A0 17 08 
1E 93 C9 54 56 56 76 CF 3D F7 20 85 0A 1C A8 56 AB 51 2D 05 37 72 A5 E6 C4 66 B3 0D 0E 0E EA 74 
3A 93 C9 04 EF 8A 40 7C DE BC 79 06 83 E1 D1 47 1F 85 85 1B 1D 1D 05 FC 3B 7E FC F8 6B AF BD B6 
76 ED DA 58 2C 46 DD 35 76 0E 73 96 C0 8E 42 8D 01 56 11 B4 08 82 90 97 97 07 32 09 29 78 40 00 
44 FF 3C CF E3 27 00 E1 0C C3 04 83 41 95 4A E5 72 B9 50 6B 72 B9 E7 CF CD CD CD CD CD 1D 1E 1E 
46 D5 0B 9C A1 D9 6C 4E A5 52 AD AD AD 70 02 F0 B1 84 10 50 0E A7 4E 9D 3A 7E FC 38 3E 0C A5 A2 
0E 9C E3 38 8B C5 32 3A 3A 0A 3F 49 23 2B 42 88 4A A5 F2 78 3C A0 AF 01 A2 A0 84 F8 DB AE AE AE 
F3 E7 CF 1F 3F 7E BC B5 B5 55 52 AA ED 90 53 45 56 66 64 64 04 81 28 AD 4F A0 89 38 EA BA 71 5D 
AE BE E2 3F 77 41 1B 51 E7 1C 8F C7 A7 4C 99 92 59 86 26 29 35 DF 8D 8D 8D 58 1F 54 CC 75 76 76 
52 97 08 89 12 04 C1 6E B7 E7 E7 E7 A3 C2 A4 BB BB 9B 6A 0B 58 74 E4 51 F7 ED DB A7 D5 6A 81 6B 
68 47 18 C9 48 9F 22 03 89 2A 02 B8 56 40 83 FE FE 7E BA 20 D4 82 7C B1 4B F1 B7 5F 7F C5 EB C9 
64 12 16 EB 9D 77 DE E9 EC EC B4 58 2C D4 95 1B 0C 86 D2 D2 D2 7F F9 97 7F 41 20 87 7A 6B 14 7F 
A0 10 9E 28 59 A9 2B BA D0 79 00 A6 C4 6C 36 1B 8D C6 54 2A 65 B3 D9 02 81 C0 CC 99 33 1F 7A E8 
A1 CC 4A BA 70 38 CC 30 CC E6 CD 9B 51 E7 09 69 B6 D9 6C 28 43 C7 DA F9 FD 7E F0 75 24 83 03 A0 
1D 21 90 4E 7C 9E D6 D3 26 93 C9 48 24 82 5C 02 FC 15 51 AA B7 7C 3E 1F D8 AC CF 59 38 68 35 0A 
9D 81 1E 51 EF 8E E0 0D A6 0A 62 27 CB 32 50 06 9E 8D 42 68 D4 F7 B2 2C 8B 74 05 21 04 CC 1E CD 
F4 E0 6F 93 C9 E4 F0 F0 30 68 CF 64 32 59 58 58 A8 56 AB 0F 1D 3A F4 E4 93 4F 3E F4 D0 43 2F BE 
F8 22 AA CF 32 03 51 92 11 B2 C2 C7 52 CF 00 2F 4D 2E 15 2B 7E 81 52 48 39 70 10 E0 08 73 F0 AB 
4C 18 E5 F1 78 06 07 07 A1 1B 9D 9D 9D 60 E3 F0 2B 4A D4 CF 9D 3B 97 61 18 BC 7E 20 10 A0 CA 43 
07 67 65 86 1E F8 07 A4 94 66 CE B0 6E 10 03 A2 4C 21 81 B5 1A 1E 1E 26 4A C4 28 67 54 AD 7C 51 
EB 70 45 17 1B 8F C7 9D 4E 27 D0 4E 7D 7D FD 5F FE F2 17 8E E3 A2 D1 28 05 57 A5 A5 A5 FF FC CF 
FF 6C 34 1A 91 1A 16 95 0E 71 B3 D9 6C 30 18 F0 19 93 C9 74 A5 5F 8C 2C 1C 32 5D 84 90 44 22 81 
E6 17 F8 E7 E9 D3 A7 DF 7B EF BD A0 10 89 D2 DE C5 F3 FC EF 7E F7 3B 90 93 68 29 88 C5 62 C0 D8 
20 EB 09 21 B4 31 87 28 09 A8 EC EC 6C 24 E5 F1 45 81 40 C0 66 B3 A1 B1 00 61 1B 32 84 C0 36 D0 
52 10 95 DC E7 36 AA 23 DA 41 0A 64 74 74 54 AB D5 9A 4C 26 8B C5 82 82 12 54 BA 11 42 CC 66 33 
5A 99 00 37 30 7C 8D 28 21 0D 6E 82 DA C0 54 2A 65 30 18 40 F9 52 F3 8F 6C 35 60 2D CA D6 78 9E 
EF EF EF DF BA 75 EB 93 4F 3E 59 57 57 87 28 0B 3C 16 AB B4 11 02 8C 31 4A EF 9B A4 54 3E E0 A5 
A8 D4 D2 8B 62 D7 2F 50 1B 51 14 09 52 00 EC 6E 59 59 19 D4 06 54 0A B6 43 92 A4 FE FE 7E AC 7F 
7B 7B 3B A0 16 40 0D 8A 43 08 21 0B 17 2E A4 95 46 91 48 04 F6 14 A5 D1 F8 00 52 1A 58 0A 54 0B 
00 3E D0 1A 23 D8 29 04 87 88 33 25 A5 30 08 B7 C5 45 4D E7 97 E6 1B 09 21 78 7A 38 1F 59 A9 DF 
C7 F3 59 AD 56 90 78 81 40 00 25 8B 94 7F C7 67 B0 70 C8 14 65 96 B9 48 4A 63 24 AC 1A 97 D1 1E 
89 1F C2 8F 61 69 D0 5B 04 C9 C6 1D 50 AD BF 66 CD 1A 42 88 D9 6C A6 10 EB FC F9 F3 BB 77 EF D6 
68 34 26 93 29 14 0A D1 7C 20 D5 6A D8 7E 46 19 12 41 77 11 EE 94 10 02 3D A4 B1 25 80 0D 80 F7 
A7 CA 74 3E 05 E4 3E 75 61 5F 51 75 85 D4 3C C3 30 28 52 43 FA 14 2B 83 AA 20 3C BC C1 60 08 85 
42 78 65 00 01 3C 12 BC 22 E2 AB 78 3C 8E 18 06 6F 21 29 A5 A1 23 23 23 28 8D 4A A7 D3 0F 3F FC 
F0 AE 5D BB B0 A4 4C 46 1B 2A 12 00 18 61 9A 48 24 9C 4E 67 59 59 D9 EA D5 AB E9 0F 59 A5 74 11 
17 58 0D 46 29 AB C2 3E 52 79 C5 45 BB 2B 48 06 D9 83 0B 20 E5 73 64 2B 91 48 C0 08 22 4D BD 6C 
D9 B2 CC CF D3 F6 A0 A3 47 8F C2 36 9D 3B 77 0E 48 01 EA 0A CF 96 95 95 55 56 56 46 31 3C 80 3A 
CD 5D 13 A5 72 13 89 0A 48 0E DD 20 6A 9B B0 F8 68 EC 02 5D 84 BA 0E 88 34 C0 3C A3 B4 C5 7E 89 
3D 56 3C B6 C4 62 B1 7C F0 C1 07 7E BF 9F 66 A2 10 7E DC 7E FB ED 40 6E 20 F1 C3 E1 30 D2 DC B4 
34 9E 42 7C 50 C9 48 54 42 46 61 DA 61 ED F0 19 DA A9 80 D6 3B D4 85 52 F5 86 E9 CA 8C DF D6 AE 
5D DB D9 D9 D9 D8 D8 88 38 10 1B 70 EC D8 31 A4 8C 71 73 10 27 A8 47 19 19 19 81 C4 E3 19 70 67 
9F CF 07 B0 04 C2 03 01 27 88 AB 68 34 1A 8D 46 E1 09 61 86 68 B2 07 E2 FB 9F 28 29 C6 06 A3 50 
89 4A 2D 51 22 A5 C9 93 27 4B 92 A4 D7 EB 91 1C CA C9 C9 31 18 0C F8 30 A0 AF C5 62 61 59 76 74 
74 D4 62 B1 C0 F3 03 44 E4 E5 E5 8D 19 33 C6 E3 F1 BC F2 CA 2B 80 EB D4 90 D3 20 19 76 C4 64 32 
CD 9F 3F 7F EA D4 A9 55 55 55 1A 8D 06 B5 3B D4 AC FC 2D CD B5 14 E7 D3 7A 17 BC 05 F8 3C 56 69 
50 44 D9 DA E5 6E 22 65 34 15 E0 CF 91 69 38 73 E6 0C 51 C0 24 00 E4 C5 8B 17 71 DB 8E 8E 0E D8 
65 86 61 C0 81 11 42 E6 CC 99 43 08 B1 58 2C 78 5F 46 E9 98 85 B5 C5 13 A6 52 29 97 CB E5 72 B9 
F0 5B D8 32 48 1D 52 06 F8 4C 65 65 25 92 C0 81 40 80 10 52 51 51 31 38 38 E8 74 3A F1 78 90 73 
58 43 64 B9 AE 74 EB FF EB 17 0F 8F 9F 4E A7 77 ED DA 25 2A 6D C1 08 76 A7 4D 9B 56 5B 5B 8B E4 
18 2D E1 CD CE CE C6 EC 4D 59 96 01 CF F0 F2 A0 37 21 82 99 04 8F AC 54 09 A6 D3 69 88 97 46 A3 
71 3A 9D 68 F4 D4 EB F5 B0 76 B0 6D E8 0A CF CB CB EB EF EF 37 1A 8D D9 D9 D9 D7 5D 77 DD 85 0B 
17 FE FA AC 3C 9F 4E A7 EB EB EB 1B 1A 1A 16 2C 58 80 0D 83 7D 85 BD 80 7F 20 19 60 43 96 65 5A 
DD 0F BF 94 59 52 43 08 01 C6 0E 06 83 99 31 06 32 16 70 6E 57 BA A0 50 0F 30 0A 44 69 C6 47 7E 
B9 A2 A2 E2 B6 DB 6E 03 63 01 5B 86 94 A9 DF EF 77 BB DD C1 60 10 2B 89 39 06 3E 9F CF 62 B1 C0 
8E A0 6E 7E 68 68 E8 C2 85 0B BB 77 EF A6 5F 04 D3 09 05 13 45 71 FD FA F5 0B 17 2E 74 BB DD F8 
21 8C 9A C9 64 82 8D 23 84 D0 78 F5 73 28 37 B8 26 FA 19 9A A1 C1 58 03 80 20 5A 79 FF 39 D8 41 
CA 98 49 05 9D D1 E9 74 F3 E6 CD 3B 73 E6 0C A8 35 49 19 2A D7 DB DB EB F3 F9 44 51 F4 78 3C F4 
0F 81 4D 78 9E 5F B0 60 41 22 91 80 60 A0 BB 12 31 30 DE 1A B5 B2 1C C7 AD 5E BD 7A C5 8A 15 00 
3E 70 71 88 59 C0 FD 60 0B 08 21 80 48 74 EC 83 28 8A 34 F9 8C 2A 11 DC ED CB 6A EC F8 2B 52 3D 
72 E4 48 4F 4F 0F A3 8C 24 42 25 C0 75 D7 5D 07 89 C7 F2 85 42 21 B5 5A 3D 30 30 80 88 0B D9 BF 
48 24 82 FA 49 90 D4 46 A3 11 7A 88 D1 09 10 68 34 10 C8 B2 8C DF A6 D3 E9 E1 E1 61 93 C9 84 5F 
21 BC B6 D9 6C C8 F5 61 B9 41 82 8D 8C 8C 4C 9A 34 69 D5 AA 55 60 71 E1 76 44 51 FC F0 C3 0F 09 
21 D0 2B 98 09 8D 46 E3 76 BB 81 15 21 20 E5 B3 3B 00 00 20 00 49 44 41 54 4F B4 6C 48 A5 52 75 
77 77 D3 C4 37 0A 2C 91 62 62 95 72 3C 98 79 08 87 D5 6A 45 8F 3C ED D9 BD A2 2B 91 48 B8 DD 6E 
60 78 36 63 A0 53 2C 16 F3 7A BD 79 79 79 F8 22 10 B0 44 41 B0 B0 44 26 93 C9 66 B3 0D 0F 0F 23 
B5 03 92 0C 2F A2 52 A9 B2 B2 B2 0E 1C 38 00 61 62 94 99 88 78 C7 92 92 92 67 9F 7D F6 C6 1B 6F 
B4 D9 6C 70 2F 88 A3 FC 7E 7F 20 10 A0 1C 1B 5E E7 F3 4D 4C A6 43 83 D6 D1 10 83 BE 0B 30 0E 8D 
EA 2F 79 31 CA A8 38 1A BB 32 0C 33 71 E2 44 D4 DC 40 78 24 A5 63 EB E2 C5 8B 98 21 80 E2 72 14 
42 CB B2 9C 9F 9F 3F 66 CC 18 6A 6E 58 96 CD CD CD 85 85 32 9B CD 30 F1 60 1C BA BA BA 08 21 91 
48 84 72 30 08 3D 10 74 20 70 40 5E 1A 0F 00 C9 94 24 69 EC D8 B1 58 7C 00 3A A4 2B 3F 27 CF FC 
77 BD FE 4A 79 7D F4 D1 47 14 31 82 97 5F BA 74 E9 84 09 13 E0 C1 B0 7F D0 10 50 20 88 12 01 D9 
B1 28 06 83 81 55 46 36 40 BE 49 06 CD 05 57 80 44 02 0C 36 AA BA 09 21 B1 58 8C 26 B2 11 85 8F 
8E 8E A2 FB 11 6E 73 DD BA 75 14 18 13 42 74 3A 5D 43 43 43 57 57 17 B0 0A 32 69 0C C3 D4 D4 D4 
D0 74 16 CC 2A 7D C9 C3 87 0F C7 E3 71 3A 3C 02 8D 17 78 E0 40 20 90 48 24 B2 B2 B2 76 ED DA 05 
A2 65 78 78 B8 B3 B3 13 9C 2D 64 E5 8A 2E 8E E3 4A 4A 4A D0 FC 41 32 EA E0 B5 5A 6D 7F 7F 7F 28 
14 8A 46 A3 A9 54 CA EB F5 32 0C 13 8F C7 31 B0 63 70 70 10 A6 2D 91 48 BC F4 D2 4B BF FC E5 2F 
3F FC F0 43 AD 56 6B 30 18 30 88 00 6C 47 4B 4B 0B 32 01 14 97 62 0B AE BB EE 3A AB D5 0A BB 09 
FF 8F AE 48 B3 D9 DC D9 D9 09 FD A1 9B F8 F9 C9 34 4A 60 64 9A 12 A2 50 C1 68 9B 94 94 F9 FF 9F 
C3 76 00 A5 67 86 DF E8 F6 AE AE AE 86 32 10 45 E1 55 2A 55 43 43 03 7C 26 FD 30 FC DB B4 69 D3 
F0 F0 F4 4D AB AA AA B0 C5 98 7C C3 30 0C 02 8D EE EE 6E A0 4D 3A CB 03 8F 87 15 46 2E 57 AB D5 
FE E8 47 3F FA A7 7F FA A7 9E 9E 9E 91 91 11 E0 55 6C 0A 21 84 02 16 00 81 2B DD F7 2F E4 62 D3 
E9 F4 E8 E8 68 5B 5B 5B 66 61 B4 56 AB BD E6 9A 6B E0 C4 65 A5 23 11 89 32 68 14 C0 2D 0D 30 90 
89 A6 E0 01 7D 58 90 18 6C 3F ED 61 63 95 52 2C FC D0 68 34 5A AD 56 93 C9 04 81 03 80 81 27 41 
E7 8E 20 08 16 8B 65 FE FC F9 88 25 E0 58 08 21 87 0E 1D CA CC 68 C7 62 B1 EA EA 6A 42 08 A3 8C 
81 42 44 0A 70 7B EA D4 A9 DE DE 5E A3 D1 88 50 1E 8F 07 7F EB 72 B9 38 8E 6B 6A 6A 7A F6 D9 67 
1F 7C F0 41 34 5E 94 95 95 01 38 7D 0E A7 7A B9 4B A7 D3 95 94 94 10 42 C0 1E D1 67 40 4C B2 67 
CF 1E BB DD AE D1 68 60 E3 51 75 10 8F C7 B3 B2 B2 F4 7A BD DD 6E DF B3 67 CF F1 E3 C7 1B 1B 1B 
7F F7 BB DF 3D FA E8 A3 C7 8E 1D 83 33 07 65 EF F5 7A 01 C2 69 61 0D 58 87 69 D3 A6 E1 95 E1 39 
69 A2 2F 99 4C A2 BA 85 28 81 EB FF 33 2D 2C 2A 9D E2 54 2B 40 6F AA 54 2A AD 56 4B 9B 78 C8 E5 
E7 1A 67 5E 34 72 06 EF C2 30 0C EA 8D E8 A8 2E 64 41 5B 5A 5A 3A 3B 3B 89 52 B3 8A 7F B0 2C 3B 
73 E6 4C E4 EE 81 35 24 49 2A 2B 2B 23 0A B7 84 C8 13 EC 43 47 47 07 22 1A 04 B7 B0 1A 94 D4 40 
19 C6 D6 AD 5B 3B 3B 3B 87 86 86 7E FA D3 9F FE FE F7 BF F7 7A BD 40 28 E8 51 A6 4A 08 C2 F6 4A 
F7 FD 0B B9 78 8E E3 8E 1C 39 92 E9 C4 18 86 99 3B 77 AE DB ED EE EB EB 73 B9 5C B4 E9 1B C1 24 
4C 54 32 99 6C 6F 6F 3F 7D FA 34 E6 71 60 48 47 61 61 61 45 45 45 6E 6E 2E F5 57 B0 76 08 9D C1 
D4 0D 0C 0C 34 34 34 74 76 76 62 4C 93 5A AD 2E 2A 2A AA AE AE 2E 2E 2E CE CA CA 02 1F A3 D5 6A 
11 4A 05 02 01 B0 32 CB 97 2F 3F 7E FC 38 72 83 20 63 8E 1E 3D BA 61 C3 06 18 57 A0 0E 8D 46 33 
7E FC F8 96 96 16 2A 7C D4 D0 FA FD FE 1D 3B 76 70 1C 37 66 CC 18 10 B9 82 20 80 16 57 A9 54 ED 
ED ED DB B7 6F 17 45 31 18 0C BE FB EE BB 07 0F 1E 5C BE 7C F9 D7 BE F6 B5 A2 A2 22 54 30 5F D1 
25 8A 62 41 41 41 55 55 D5 F9 F3 E7 89 52 BC 0E B6 93 E3 B8 9D 3B 77 56 56 56 3A 1C 0E 40 00 AD 
56 AB D5 6A 43 A1 10 C6 8E 74 77 77 BF F9 E6 9B A0 64 04 41 38 77 EE 5C 7B 7B FB F4 E9 D3 97 2C 
59 32 6D DA 34 14 70 82 64 C2 7F 01 C3 E2 F1 78 5F 5F 5F 6E 6E 2E A3 8C EB 8F 46 A3 28 64 39 71 
E2 04 A6 54 64 42 CA F4 DF 70 18 46 26 2E 15 04 C1 EB F5 A2 84 08 21 3A 4D 3B 7D 8E 6F A4 02 80 
6F C4 83 49 92 34 7E FC F8 EC EC 6C 14 1B D3 4F 7A BD 5E CA F6 01 D9 32 0C 53 54 54 84 52 F8 94 
72 48 41 32 99 2C 28 28 C8 CF CF EF EB EB A3 59 19 FC 83 E7 F9 13 27 4E B8 DD 6E 9B CD 46 49 69 
D4 82 A7 D3 E9 40 20 70 EA D4 A9 F7 DE 7B 0F 11 63 24 12 39 79 F2 64 73 73 F3 C4 89 13 AF BF FE 
FA CA CA CA D1 D1 51 7C 2F 4D CC 7C 4E 48 FC F7 BB 78 B5 5A 7D F8 F0 61 A2 F4 7D C1 A5 5C 75 D5 
55 08 5D 60 C3 80 FD E8 EB 1D 3B 76 6C D7 AE 5D 8D 8D 8D C0 00 80 4C 06 83 E1 C0 81 03 84 90 EA 
EA EA 15 2B 56 4C 9D 3A 55 AF D7 03 13 02 E2 A3 F9 F5 C8 91 23 99 CD 66 2C CB B6 B4 B4 7C F0 C1 
07 36 9B AD B6 B6 76 D5 AA 55 A8 6E 43 81 18 8D F4 4A 4A 4A D0 1D 8F 64 80 46 A3 19 1C 1C 0C 04 
02 80 67 1C C7 D9 6C 36 9F CF 37 63 C6 8C 96 96 16 EA 8D 69 E2 8E 10 F2 E1 87 1F AA 54 AA 55 AB 
56 15 14 14 80 2F 41 7B CE 99 33 67 F6 EC D9 73 E6 CC 19 08 28 B0 EB B6 6D DB EA EA EA D6 AE 5D 
BB 62 C5 8A 2B 5D 50 94 D7 CE 9A 35 AB B9 B9 19 8B 06 49 02 A5 D1 DF DF FF C7 3F FE F1 E1 87 1F 
F6 78 3C F9 F9 F9 91 48 44 10 84 FC FC 7C 8F C7 D3 DD DD FD C4 13 4F 60 56 65 3C 1E 87 64 24 12 
89 83 07 0F 76 76 76 BA DD 6E BC 2C 40 2F A8 60 95 32 F8 EB E4 C9 93 EB D6 AD C3 D7 01 8F A8 D5 
EA C6 C6 C6 A7 9F 7E 9A 57 66 6A 90 8C A9 9C 9F AF 8D CC 7F 9C EF 94 4E A7 BD 5E 6F 6B 6B 6B 61 
61 21 28 5F F2 37 38 46 AA CC 10 0F EA CC CD 66 73 61 61 A1 D7 EB 85 29 41 00 49 27 D9 50 92 46 
AF D7 97 95 95 01 4C A1 59 07 56 C0 E1 70 14 17 17 63 34 1E BE 02 75 4E 1A 8D 66 F7 EE DD A9 54 
EA A6 9B 6E B2 5A AD A8 55 C4 07 F0 F0 CF 3C F3 0C 40 3E 20 49 3C 1E 0F 87 C3 27 4E 9C 18 1C 1C 
7C E4 91 47 90 45 CB E4 96 AE 74 DF BF 90 8B 5B B5 6A D5 D6 AD 5B 11 F2 C2 E6 B9 5C AE 9B 6F BE 
19 46 82 96 59 01 BE 73 1C B7 6B D7 AE 3F FC E1 0F 98 8F 06 D0 0F 36 15 7F 6B 36 9B 7B 7B 7B 3F 
F9 E4 13 86 61 9C 4E 67 7E 7E 3E 2A 5A CE 9D 3B F7 EF FF FE EF 68 D1 D0 68 34 9C 32 DA 0C 7C 06 
5C 47 53 53 53 4B 4B CB F8 F1 E3 4B 4A 4A 50 00 6D 32 99 30 3A 01 11 29 8E 4F C2 9C 01 9E E7 F3 
F3 F3 51 30 C5 30 8C CF E7 33 9B CD 45 45 45 1F 7F FC 71 38 1C 66 95 51 F3 B2 32 86 87 65 D9 AE 
AE AE 3D 7B F6 B4 B5 B5 F5 F6 F6 0E 0D 0D 9D 3C 79 72 FB F6 ED 6F BF FD 76 5B 5B 1B F2 93 88 F2 
21 AF E3 C6 8D BB F1 C6 1B 51 CE D6 D3 D3 93 29 C1 78 60 B4 68 D2 A1 38 AC 72 DA 04 58 C7 FC FC 
FC 1D 3B 76 50 2F 0D 0F 83 3F 1F 19 19 39 72 E4 08 6A C4 00 3B CF 9D 3B F7 D6 5B 6F BD F1 C6 1B 
E0 4E 81 53 70 1F 98 F6 6F 7D EB 5B 88 E1 8F 1E 3D 1A 8D 46 A9 A3 A3 86 BC A9 A9 C9 EB F5 A2 20 
5E 10 84 A6 A6 A6 97 5F 7E F9 ED B7 DF 46 FA 1B 48 8F DA 4D 28 9B C9 64 5A B6 6C 19 50 34 B2 F3 
E9 74 FA C2 85 0B 99 CD BE 2A 65 4C 0E 21 A4 AE AE EE D4 A9 53 75 75 75 EF BF FF FE E9 D3 A7 E7 
CC 99 23 08 42 24 12 D9 B3 67 0F 73 A9 6B FE FC F9 76 BB 1D 90 0F AD 98 B0 92 78 B5 13 27 4E A0 
FA 8A 42 50 64 1A E1 06 C1 CC DD 79 E7 9D 08 F5 51 A8 04 7F A5 D7 EB B3 B3 B3 F7 EF DF 8F 6F 41 
C2 8C 28 0E 1F 83 11 90 E8 82 CA 35 34 34 BC FD F6 DB 7F FA D3 9F 48 46 C5 18 DA 12 00 31 1E 79 
E4 11 14 6C E0 03 60 1C 78 65 5E EB 7F F3 C5 83 8C 92 94 99 96 2A 95 0A 0D 26 8C D2 3D 4C E5 4C 
92 A4 63 C7 8E 3D FB EC B3 B2 2C 83 02 C1 66 A3 CA 14 AF 07 1A 5A 14 C5 37 DE 78 A3 A8 A8 88 E3 
B8 BC BC BC 96 96 96 DF FE F6 B7 18 55 9A 4C 26 CD 66 33 1D C6 01 C3 C6 29 DD 37 AD AD AD 2F BE 
F8 E2 6D B7 DD 86 F2 20 40 79 8E E3 22 91 48 71 71 31 21 84 53 26 29 10 42 DA DA DA E6 CD 9B 27 
CB 72 24 12 71 B9 5C F1 78 3C 14 0A DD 7D F7 DD 3F FB D9 CF 10 30 60 2F E1 ED 69 2E EE CC 99 33 
F5 F5 F5 72 C6 88 2A 1A DB B0 2C 8B 62 71 83 C1 70 FB ED B7 33 0C 03 87 CC 64 4C E2 40 1D 12 D6 
07 14 2E 51 BA 28 F0 13 B0 73 06 83 E1 27 3F F9 C9 03 0F 3C 00 DB 41 03 2D 50 B5 43 43 43 EF BD 
F7 DE CE 9D 3B D3 FF 71 B6 25 45 5F E0 78 01 22 96 2C 59 B2 78 F1 E2 70 38 9C 93 93 53 54 54 04 
B8 0E 13 09 EA 0B 86 F2 E0 C1 83 27 4E 9C A0 C4 49 A6 C6 52 12 85 42 7A AC 09 F4 93 28 E9 B8 44 
22 E1 72 B9 88 32 50 07 F9 58 1A 6D C6 62 B1 EE EE 6E 74 24 8E 19 33 06 26 06 FC F9 25 05 8B 53 
A6 60 08 19 E7 37 22 AC AD AE AE 46 07 39 51 66 7C E0 19 A0 78 A8 0A A8 A8 A8 28 28 28 A0 E5 56 
C8 64 20 14 CC CD CD BD FE FA EB 5F 7E F9 65 7C 0B 18 41 9A DF F7 78 3C 1F 7C F0 C1 07 1F 7C 40 
F3 34 20 B7 61 17 80 2C B0 74 66 B3 79 DD BA 75 59 59 59 20 7E A4 8C 73 7B 3E 87 E5 FA BB 5E EC 
85 0B 17 60 2C 29 AF 3D 65 CA 14 FC 6F 66 54 46 08 19 18 18 F8 CB 5F FE 02 FB 91 4A A5 40 8A 56 
57 57 AF 5B B7 EE B6 DB 6E 5B B4 68 11 65 11 61 F0 7E F9 CB 5F AA 54 2A BF DF FF DA 6B AF 0D 0E 
0E 42 AF 30 7B AE B0 B0 70 C1 82 05 B7 DE 7A EB 9A 35 6B D0 C7 40 08 B1 58 2C C9 64 B2 B1 B1 B1 
AB AB 0B C4 2C AD DD E1 79 BE B4 B4 14 CC 2A 76 51 96 E5 A6 A6 26 94 DA 58 AD 56 74 3C 1B 0C 86 
69 D3 A6 AD 59 B3 C6 64 32 41 9A 51 5D 4D 73 36 F8 09 36 55 54 CE 99 C0 42 50 DD 13 04 E1 E9 A7 
9F C6 7C 27 30 72 10 29 9A 64 43 C3 04 E8 13 4A C1 D1 EC 1F 98 D2 50 28 54 52 52 B2 72 E5 4A D4 
15 E0 C4 35 78 4E CA D7 D1 46 27 46 49 93 32 CA 81 33 84 10 A8 E2 F4 E9 D3 6F BC F1 46 49 E9 6D 
5F B3 66 4D 2C 16 C3 30 38 5A 58 0B E6 10 EE 17 0F 9C 56 A6 80 C3 E3 C1 DE 63 F5 68 2D 58 38 1C 
06 24 A1 46 C4 68 34 CE 9F 3F DF 60 30 A0 4C 12 83 AA 51 F6 84 AA 3D 5A A3 83 B7 8E C7 E3 B0 A4 
97 BC 48 C6 09 02 E0 1D 60 5E A3 D1 A8 CB E5 1A 37 6E 1C 1A 3E 25 65 9A 38 3E 4C D3 42 B3 66 CD 
C2 F4 09 6A 7A F0 9C 28 F3 A8 AD AD AD AA AA 2A 2C 2C 24 4A E3 28 C3 30 78 23 88 2B 48 2C 9A 89 
21 84 80 D7 C1 07 40 14 55 55 55 6D DC B8 D1 64 32 C1 7F 88 4A A3 16 F9 F2 B4 91 EF EE EE A6 35 
56 50 A4 B2 B2 32 D8 33 9A 26 82 D9 A8 AB AB 6B 6D 6D A5 11 9D 4E A7 9B 33 67 CE AA 55 AB 4A 4B 
4B 51 A0 D3 DF DF FF 7F FE CF FF 81 DF 9B 31 63 C6 BA 75 EB 2C 16 4B 6B 6B EB 89 13 27 C0 C7 A2 
FB 6E EC D8 B1 3F F8 C1 0F 72 72 72 6C 36 5B 77 77 F7 C6 8D 1B 7F F3 9B DF 1C 3D 7A D4 EF F7 8F 
1F 3F 7E F9 F2 E5 E3 C7 8F 47 AD 0C 9C 0F 0C AA 56 AB CD CA CA A2 CD 81 82 20 60 8C 37 42 44 F4 
52 60 22 F0 C6 8D 1B F5 7A FD CB 2F BF 8C 72 16 D0 74 28 00 CA CE CE 0E 04 02 D2 67 86 A3 22 F3 
09 FE F6 91 47 1E C1 1C 1A 94 41 66 CE 4A 03 D9 0B 14 80 B4 1E 15 23 39 A3 A6 CF 68 34 22 57 79 
F7 DD 77 13 42 0E 1F 3E EC F5 7A 11 0D 42 91 90 1E 00 62 47 C2 E0 53 1E 06 9A 53 55 55 75 D7 5D 
77 A1 1A 2E 1A 8D 3A 1C 8E F2 F2 F2 C5 8B 17 37 34 34 8C 8C 8C C0 A5 E0 F5 69 76 17 78 4F 92 24 
3A AB 01 D3 47 51 6C 8D 2A 16 5E 99 F0 0D 4A 03 8E 11 31 55 6E 6E 2E 46 71 13 42 10 80 50 9A 1D 
13 8A B1 56 6A B5 1A 4F 45 EB B0 3F 7B C1 6A 7F 8A 6B 81 31 E2 79 7E C9 92 25 75 75 75 58 46 28 
0C EC 11 A6 93 10 42 16 2C 58 00 F7 0B A8 0C C7 0E 57 89 56 B8 47 1F 7D F4 E7 3F FF 39 06 DE 82 
5F A0 DD 8C 99 D5 7C 92 52 A1 E9 70 38 90 33 43 62 63 FD FA F5 1B 37 6E A4 30 FE 53 EB FF A5 C5 
8D 20 30 25 E5 64 22 9E E7 6F B9 E5 16 F8 46 BA 79 00 51 9B 37 6F 0E 04 02 90 27 49 92 9C 4E E7 
3D F7 DC 33 6E DC 38 78 0F 49 92 5C 2E 57 59 59 59 24 12 B9 F7 DE 7B 57 AF 5E 8D 93 8F DE 7F FF 
FD 96 96 16 EC 37 6C F3 1D 77 DC 31 79 F2 64 83 C1 00 CE 36 99 4C 8E 1F 3F DE E3 F1 DC 74 D3 4D 
B7 DE 7A 6B 71 71 31 06 A5 20 F4 87 C5 42 AD E3 F9 F3 E7 FB FB FB E1 4C E0 9D 56 AE 5C 69 B7 DB 
87 86 86 5C 2E 17 FA 3C 64 59 B6 58 2C F9 F9 F9 95 95 95 E7 CF 9F 47 83 08 6D A8 8B C7 E3 34 58 
07 6E A4 36 C8 E9 74 16 15 15 3D F4 D0 43 79 79 79 92 72 AE 01 CB B2 87 0F 1F EE EF EF A7 49 64 
1A D4 21 EE 42 20 04 C5 86 8D 20 84 80 72 C0 FB 8E 1D 3B 76 CC 98 31 1D 1D 1D 10 7A A2 E4 C1 00 
CC D0 85 00 81 46 BE 87 42 E8 B5 6B D7 7E EB 5B DF 92 65 D9 ED 76 8F 8C 8C 60 5A 6C 32 99 9C 3C 
79 72 6B 6B 2B 6A 95 40 6E E3 95 81 75 E1 46 10 6D 12 42 8C 46 E3 83 0F 3E 98 4E A7 DB DB DB A1 
57 F0 CF 82 20 A4 52 A9 05 0B 16 C0 75 63 77 50 F2 52 56 56 D6 D5 D5 85 B1 C5 68 4F 13 04 01 B2 
41 05 57 AF D7 2F 5D BA 34 95 4A 0D 0F 0F 1F 38 70 80 BD D4 35 7B F6 6C F4 E8 50 43 4F 21 58 2C 
16 73 BB DD 87 0E 1D A2 FD B1 6A B5 1A 29 31 2C 45 4D 4D CD 9A 35 6B 60 F4 69 8B 19 F6 0B 0F 0F 
A2 7E D6 AC 59 36 9B AD A5 A5 05 DC 1E F0 0B A5 6A 29 77 45 94 61 ED 16 8B 25 14 0A 19 8D C6 BB 
EF BE 7B D9 B2 65 08 B3 21 BD 4C C6 39 93 5F 22 8B C3 23 4D 4C 94 83 84 30 76 91 56 60 70 4A B5 
77 34 1A ED EA EA 02 AC 07 10 1A 33 66 8C 4E A7 0B 06 83 14 87 F4 F6 F6 16 14 14 7C E7 3B DF 71 
B9 5C 30 A5 82 20 1C 3A 74 48 56 8E A4 36 1A 8D 82 20 4C 9C 38 11 7F E5 76 BB 93 C9 24 DA 61 EF 
BD F7 5E F4 37 11 A5 A7 09 7A 88 0D 40 D6 DE ED 76 93 8C D2 2D 42 08 A6 8C C3 5B 82 44 B5 DB ED 
E0 F7 AB AB AB 37 6D DA F4 E1 87 1F BE FC F2 CB B4 0D 47 52 0E C0 C9 8C 1B CD 66 B3 CD 66 C3 4C 
0D 8B C5 32 34 34 04 C7 08 25 07 18 A3 54 24 D4 8F 10 92 97 97 87 1A 20 3C 1E CD 89 81 40 47 8F 
A5 DF EF CF CA CA 5A BD 7A B5 DB ED 7E ED B5 D7 3C 1E 0F 66 52 E2 0E 74 04 BB CD 66 93 65 19 96 
4E AF D7 5F 7D F5 D5 CB 97 2F 77 3A 9D 00 14 DD DD DD 63 C7 8E 1D 1A 1A 92 94 6E CC DB 6F BF BD 
AA AA EA BD F7 DE F3 F9 7C 2A 95 0A 27 E4 60 DD 70 43 0C FC 5D B9 72 E5 B5 D7 5E 8B D0 1D D3 D6 
69 D4 0D 70 E8 F1 78 50 1D 05 E8 01 D6 A0 BC BC 7C EE DC B9 38 B0 04 02 00 B7 89 5A 3F 2C 1D 48 
72 A3 D1 88 89 E3 97 14 2C 4C 1E A2 82 0E 5B 00 8D 42 69 C4 C4 89 13 3F FA E8 23 0C D4 A2 7F 05 
F0 3F 6D DA 34 0C 46 60 95 86 2C 4C D9 4A 28 27 5E D1 75 5E BD 7A F5 A4 49 93 FE FC E7 3F 7F F2 
C9 27 18 04 21 29 B5 78 14 DC E1 7F F1 82 AB 56 AD 5A BD 7A 75 41 41 01 B0 3D 05 EA 9C 52 94 4B 
75 E1 EF A3 6E FF 8F 8B A7 35 EF B0 FA 0E 87 83 AA 01 C6 73 40 0A 91 79 43 75 2F 42 E1 49 93 26 
61 AD E1 04 C2 E1 70 79 79 B9 D7 EB 75 38 1C 28 1B A0 79 79 E0 3D 0C D8 AC A8 A8 A0 98 3E 18 0C 
02 A7 21 A8 43 21 4E 32 99 44 E3 0F 26 82 51 93 CF 29 67 3C 11 42 20 37 E8 78 88 C7 E3 38 2E 06 
74 22 9D A1 86 29 52 8B 16 2D 5A B9 72 E5 F9 F3 E7 0F 1F 3E DC DC DC 3C 3C 3C 4C DB CC CD 66 B3 
D3 E9 2C 2D 2D 9D 35 6B D6 C4 89 13 F1 BD DD DD DD 6E B7 1B 9B 34 6E DC 38 9F CF 77 C3 0D 37 5C 
F2 54 1C C8 8A A8 F4 9E 73 1C 47 33 D7 84 10 CC D7 30 9B CD 1E 8F 07 95 6B BF FE F5 AF 3B 3B 3B 
CF 9F 3F DF D8 D8 78 E1 C2 05 9F CF 47 07 CC 21 F4 5D BC 78 F1 AC 59 B3 4A 4A 4A F4 7A 3D B4 2E 
18 0C A2 58 7F 70 70 30 2B 2B AB BB BB BB B0 B0 10 A7 0C AC 58 B1 62 C9 92 25 A7 4F 9F DE BB 77 
6F 47 47 07 5A 4F 09 21 36 9B AD B2 B2 72 FA F4 E9 C5 C5 C5 48 0F A2 2E 02 DC 2F C2 48 E8 89 DF 
EF CF CE CE 46 CD 3A 22 64 38 4C 95 4A B5 71 E3 C6 AB AE BA EA D0 A1 43 C7 8E 1D 1B 1C 1C 04 97 
03 B7 66 B7 DB 79 9E CF C9 C9 09 06 83 A8 A6 78 E0 81 07 2E 29 58 B4 BA 90 28 13 18 80 F6 01 3A 
38 8E 5B BB 76 6D 45 45 85 D3 E9 84 BF A2 46 2D 14 0A CD 9E 3D 1B 60 0D C5 F4 80 63 44 19 15 4F 
59 37 54 FF E5 E5 E5 DD 7B EF BD 03 03 03 A7 4E 9D 6A 6B 6B 6B 6B 6B 8B C5 62 C1 60 10 5F 9D 9D 
9D 9D 9F 9F 6F B3 D9 A6 4C 99 52 54 54 84 E3 89 D0 50 8E 66 3A 49 99 C1 F1 29 12 41 FE 32 9A AA 
78 6A 0C F0 0F F0 90 90 86 54 2A 85 5D E4 94 59 55 58 1D B0 58 B2 2C 6B B5 5A BD 5E DF DB DB 9B 
97 97 A7 56 AB 2F 5E BC 88 54 0F 76 9D E3 B8 68 34 4A 27 65 10 42 78 9E 47 35 29 B2 3D 2C CB 62 
64 13 A3 8C F4 C5 01 58 70 65 A2 D2 18 05 33 8C 72 16 6A ED E8 69 6A BC 52 CE 0E 4F 85 EF 85 40 
67 67 67 27 12 89 40 20 50 54 54 54 5E 5E 4E FD 1B F0 2A A0 11 54 1D 11 45 3A 9D CE C9 C9 F1 FB 
FD 28 23 EE EB EB 33 18 0C 15 15 15 85 85 85 9F 3D 31 4E A5 0C 50 85 7C 80 81 A4 A5 B6 10 85 60 
30 68 B7 DB D3 CA E8 37 A3 D1 B8 70 E1 C2 85 0B 17 66 32 EC 78 17 A2 94 DD 52 48 1C 0C 06 69 F5 
39 C3 30 3E 9F AF A8 A8 C8 E3 F1 80 BC 01 CB 35 6B D6 AC 79 F3 E6 A5 95 D1 8C B4 57 13 03 E3 C0 
C4 68 B5 DA C2 C2 42 A7 D3 89 28 11 BB 1E 0A 85 00 DB 28 46 40 8E 01 A8 15 76 67 E5 CA 95 E8 C6 
42 1E 4B AD 56 83 7E 43 C8 8A 23 C0 68 19 D0 67 2F 44 95 89 4B 9D DF 08 67 EB 76 BB 73 73 73 01 
56 59 A5 AC 1C 23 39 91 81 04 9C C1 84 14 F8 43 40 30 58 0D 5E 69 CA 41 B5 83 DD 6E 5F BB 76 2D 
9A 16 68 8D 1B C4 03 32 83 BD 03 9A B0 DB ED 58 1C 24 B4 68 F4 81 6F 24 5F 9E 36 B2 34 4C 97 94 
0E 1D FC 04 E3 6A 38 E5 48 3D 0A C7 E9 12 83 81 40 DD 29 74 09 D2 8F 7E 08 8E E3 68 54 26 2B 87 
DA D2 7F 73 4A 33 0E F2 B6 E8 54 A4 53 4C E0 82 E0 2A F1 54 C2 E5 67 0B E0 0E 2A 65 52 13 EA 6C 
70 21 C7 85 91 64 34 F5 07 16 21 93 7A 61 95 5E 44 64 4D ED 76 7B 2C 16 03 6B C2 2A 47 C4 A0 52 
2F 95 4A A1 9E 0E 04 26 F4 04 0C 04 4E 0D 81 D8 51 02 D0 68 34 82 02 05 C3 8E 4A 23 20 05 A8 01 
BE 1D 16 01 05 FA B0 29 80 AC 30 13 00 51 50 48 14 06 8A 4A EB B0 28 8A 08 34 18 E5 A4 27 59 19 
EE 04 F6 8B 57 E6 32 E1 1F 48 63 C4 E3 71 A3 D1 88 43 AF 18 86 49 26 93 78 4E 5A 47 06 0D 64 94 
A4 0B 6D 07 47 CF 1A 94 13 6B 4B 08 41 DB B7 A8 4C 10 D7 6A B5 82 52 CD 8F 2A 0B D8 26 EC 08 D8 
63 8B C5 82 E1 F1 78 2F EC 88 D9 6C C6 54 4B 26 A3 AB 13 EB 8C AA 7A 4A 86 63 05 B0 5C 58 67 A4 
28 00 A6 28 B1 8F 4A 4C 26 A3 20 8C 0A 03 F0 11 EC B8 94 71 11 05 A3 02 23 00 C1 82 6C 83 AF D2 
EB F5 28 91 35 9B CD E0 87 B1 3E 30 1F F4 C5 29 37 0E AE 0E 85 5F 82 32 F9 01 B7 E2 79 1E 21 95 
AC 9C F7 CE 71 1C 4B 69 2B DC 05 7C 31 65 A8 B1 C4 84 10 B3 D9 8C FD 43 08 67 B3 D9 80 A3 92 C9 
64 5E 5E 1E 20 38 3E 80 F3 0C 79 9E 1F 1E 1E 46 F0 43 3D 89 28 8A 03 03 03 58 17 C4 D0 78 87 BC 
BC BC 48 24 D2 DF DF 0F F5 40 DE 09 41 26 DE 16 6D 22 9C 32 DC 01 42 40 08 61 18 06 E9 0D 6C 6A 
30 18 04 E7 89 3A 7D 90 1C 08 4B 04 E5 24 D0 BE BE BE 91 91 11 38 6D A8 01 AB 9C 64 84 A9 36 3E 
9F 4F A3 D1 A0 9B 09 32 2D 08 82 D5 6A 85 7F 70 38 1C 8C 52 75 05 3D 81 32 E3 8D D0 93 4D 37 06 
06 02 33 38 80 88 A0 F3 B0 23 A9 54 CA 6C 36 23 84 A3 D9 39 08 3A 1D E2 48 5F 99 9E 66 29 64 0C 
E9 03 CF 2C 2A A3 90 29 C3 0C 8F 01 EC 30 3C 3C 8C A7 95 94 B6 7A EC 3D 9C 67 42 39 43 D2 6E B7 
83 B1 C4 33 A8 95 C9 7D B0 35 88 1B 89 72 26 07 14 15 BA 6A B7 DB 01 F3 E0 9C 01 BF 69 00 C2 2B 
1D C0 A0 3A 11 A0 76 74 74 A0 4C 37 18 0C BA 5C 2E 58 8A 78 3C 8E C3 61 69 BF 35 CA DF 60 A7 F0 
B7 68 46 A3 9E 93 51 B2 5F 54 27 D1 C0 8D F1 65 14 91 32 4A 11 39 B0 00 06 2C 50 EC 8D D7 41 F7 
8C 2C CB 74 4A AD C7 E3 C1 E9 5D 38 B8 0E AE 05 E2 84 BA 02 59 96 9D 4E 27 CB B2 7E BF 1F D6 04 
A6 04 2B 23 29 85 F5 68 4B 60 94 1C 35 75 48 C9 64 32 3B 3B DB E7 F3 61 B3 24 49 B2 58 2C 3C 34 
4A 52 BA 2E 46 46 46 78 A5 07 1C 66 1B CA 0D AE 05 50 C1 6A B5 FA FD FE F3 E7 CF 03 BC E1 D8 2D 
B3 D9 1C 0E 87 23 91 48 30 18 44 27 B1 DD 6E 1F 1C 1C 44 B6 2A 1C 0E 03 3E 61 74 17 D2 80 8C 32 
4F 1A CB 5D 50 50 80 9F 80 1D 65 59 16 AA 45 6B CA B1 04 50 42 C4 18 60 95 F0 9E 88 2E 00 A7 51 
00 04 28 22 08 C2 89 13 27 EA EA EA 3A 3B 3B FB FB FB 75 3A 5D 42 39 E8 C2 E1 70 94 94 94 4C 9A 
34 A9 AC AC 0C B3 79 60 A7 19 86 C1 54 28 34 B9 5A AD D6 8B 17 2F EA F5 7A E0 58 AC CC 9E 3D 7B 
3A 3B 3B 2F 5E BC 88 C8 10 D6 0E 8B 59 51 51 51 59 59 39 71 E2 C4 F2 F2 F2 54 2A 85 96 14 59 39 
3D 0A BB 85 B0 F6 D0 A1 43 30 79 34 3F 0E 35 5E B8 70 21 00 C2 E0 E0 E0 E9 D3 A7 8F 1D 3B D6 D6 
D6 46 13 FA 39 39 39 C5 C5 C5 B5 B5 B5 E3 C6 8D A3 75 5E 70 29 91 48 A4 A7 A7 07 EF 8B 73 63 19 
E5 BC A0 D2 D2 D2 25 4B 96 4C 99 32 05 80 16 FD 00 70 B0 3B 76 EC 00 F2 C7 B2 50 6E 63 FA F4 E9 
38 DF 56 10 84 97 5E 7A A9 BB BB BB B3 B3 93 A6 88 EC 76 7B 6E 6E EE 8C 19 33 A6 4F 9F EE 70 38 
B2 B2 B2 DA DA DA 5C 2E 17 94 19 C3 23 4F 9C 38 81 EC 31 F8 1B 95 4A E5 72 B9 A6 4D 9B B6 74 E9 
52 87 C3 C1 F3 3C 24 04 9E 10 50 1F 46 50 AD 56 17 16 16 82 18 6B 6D 6D 3D 73 E6 CC 85 0B 17 06 
06 06 FC 7E 3F 02 13 B8 4D 8D 46 53 5D 5D 3D 63 C6 8C 8A 8A 0A 94 E3 03 64 79 3C 1E AB D5 0A A6 
1D 10 80 E3 B8 BA BA 3A F0 C6 C8 18 53 27 36 79 F2 64 30 40 3C CF 37 34 34 EC DB B7 CF E7 F3 85 
42 21 FA 43 87 C3 51 59 59 39 6F DE BC 9A 9A 1A 98 69 84 03 10 12 9C 21 8D 7F E3 9E 23 23 23 A7 
4F 9F AE AB AB CB E4 D2 09 21 46 A3 B1 A0 A0 60 FC F8 F1 C5 C5 C5 88 99 B1 41 E8 C9 8C C7 E3 4C 
71 71 31 06 93 C0 EA 70 1C F7 E2 8B 2F 42 21 61 35 C1 02 4B 92 74 DF 7D F7 A1 04 99 55 C6 EF BF 
FC F2 CB 68 74 84 9E 40 97 90 F6 D8 B0 61 83 DB ED B6 58 2C 9B 36 6D 7A F7 DD 77 61 C8 01 33 EE 
BF FF FE 79 F3 E6 A1 2D 20 1C 0E 63 6A EB 53 4F 3D E5 F7 FB 17 2E 5C 38 67 CE 1C F8 0A 44 11 C0 
6C 90 8F 27 9E 78 02 49 2A 56 19 CB F7 FC F3 CF F3 3C 9F 95 95 05 94 02 D7 8D 58 0E 3E 7C E7 CE 
9D EF BC F3 0E BC 4D 5A 39 72 14 7B C9 2B AD 15 30 AB D3 A6 4D BB EE BA EB F2 F3 F3 51 A5 01 82 
D7 E5 72 A1 A1 09 96 05 CB F2 C2 0B 2F EC D9 B3 87 57 8A DD D0 11 27 2A 27 9C 66 86 1C 0E 87 E3 
E6 9B 6F 5E B4 68 11 86 DF C0 88 F2 4A EB 7A 6B 6B EB 03 0F 3C 40 E3 5E 68 B2 28 8A 46 A3 F1 FE 
FB EF 77 38 1C EF BF FF FE EE DD BB 25 E5 F8 0A 1A D8 50 AC 58 5D 5D FD BD EF 7D 0F ED C5 5A AD 
F6 E0 C1 83 BB 77 EF 6E 6B 6B A3 A1 04 CF F3 50 54 56 39 87 C7 E1 70 AC 5A B5 6A FD FA F5 90 1E 
64 D8 EF B8 E3 0E 59 39 69 13 50 19 3B 7E F7 DD 77 57 54 54 9C 39 73 66 EB D6 AD 30 E1 3C CF 43 
8D 81 1A 18 86 31 9B CD 26 93 E9 CE 3B EF AC AE AE D6 E9 74 81 40 20 18 0C BE FA EA AB 87 0F 1F 
16 95 16 1F 92 91 4F C7 C0 78 49 92 AE BF FE FA 1B 6E B8 81 61 18 98 6F 59 96 F1 0F 08 06 8C D7 
E9 D3 A7 DF 7D F7 DD A1 A1 21 90 C6 00 FC 68 EE 19 1A 1A 42 FF 14 FA 1B 09 21 B3 67 CF C6 09 1C 
56 AB 15 9D 71 68 D0 69 6F 6F 2F 29 29 F1 7A BD 0F 3F FC 70 5F 5F 1F D6 5F 56 8A 37 08 21 B7 DE 
7A EB 82 05 0B CE 9C 39 F3 E7 3F FF 19 1D CF 7F 8D E2 94 C1 82 69 E5 C4 8A EC EC EC 1F FC E0 07 
38 58 9E B6 41 E2 A8 69 20 E4 D3 A7 4F BF F9 E6 9B 17 2E 5C 00 8B 0B 8A 94 02 16 DA 56 02 21 59 
B4 68 D1 8A 15 2B 68 E9 DB F0 F0 30 57 5A 5A 8A 3E 1D 51 69 E3 80 61 A6 EB C8 2A 05 4D 89 44 A2 
A1 A1 01 D6 4B 92 24 A3 D1 78 FE FC F9 FC FC 7C 87 C3 01 57 2B 08 C2 AB AF BE FA C9 27 9F 74 77 
77 1F 3D 7A B4 AB AB 2B 37 37 D7 66 B3 ED DF BF 1F 33 ED 13 89 84 5E AF 6F 6C 6C CC CE CE CE CB 
CB 1B 1D 1D 45 6C F6 F6 DB 6F BF F7 DE 7B E1 70 B8 B9 B9 B9 A9 A9 29 3B 3B 1B 90 83 F2 96 10 FA 
D7 5F 7F 9D 9E CE 07 7B BF 61 C3 06 E0 6A 8C F6 88 C7 E3 3E 9F CF E5 72 C9 B2 DC D1 D1 F1 DB DF 
FE F6 E0 C1 83 A8 B0 41 C0 06 10 82 37 A2 99 06 F8 81 C1 C1 C1 9D 3B 77 F2 3C 3F 61 C2 04 E8 B6 
C3 E1 18 1A 1A A2 CC 1B C7 71 CF 3E FB EC 13 4F 3C 31 38 38 88 60 86 86 01 29 65 20 12 2C 05 2C 
3D B4 EB C8 91 23 27 4F 9E 2C 2A 2A C2 0A A0 51 1B F3 CE 83 C1 E0 DE BD 7B 79 E5 24 76 59 19 F7 
98 4A A5 4A 4A 4A 9E 7C F2 C9 0B 17 2E 00 3F AB D5 6A D0 36 D8 05 AB D5 8A 70 DD E7 F3 35 37 37 
E7 E5 E5 E5 E6 E6 6E D9 B2 E5 E0 C1 83 CD CD CD 68 08 A2 15 D2 54 B6 10 44 45 22 91 BE BE BE F6 
F6 F6 F9 F3 E7 63 F2 80 5E AF 7F E3 8D 37 68 84 C9 29 93 F5 72 73 73 F5 7A FD F6 ED DB 0F 1D 3A 
44 69 05 24 E2 81 47 50 DE 89 80 F9 D0 A1 43 7A BD 3E 3F 3F BF B1 B1 F1 81 07 1E E8 EF EF A7 0B 
4B 94 B6 0C 4C 8A 08 06 83 70 56 68 52 9D 3B 77 2E 8C 63 2A 95 72 3A 9D 1E 8F C7 E5 72 85 42 A1 
FE FE FE DF FD EE 77 87 0E 1D 1A 1E 1E 86 4C 63 6C 6F 32 99 C4 88 09 18 53 70 66 60 0D FA FA FA 
8E 1E 3D DA D7 D7 37 66 CC 18 3A 10 0C 3A 09 9B BE 7D FB 76 70 8A 34 8F 4D 9D FC E1 C3 87 DF 7D 
F7 DD 48 24 82 76 E7 AC AC 2C 3E E3 E8 34 B8 D6 44 22 31 32 32 32 38 38 38 61 C2 04 68 5A 76 76 
36 70 1F A6 34 3D F7 DC 73 9B 37 6F 1E 1D 1D C5 F4 9D 74 3A 0D AE 58 56 06 50 50 93 04 6E B2 A3 
A3 E3 C0 81 03 A7 4E 9D 52 AB D5 59 59 59 66 B3 99 9B 3D 7B 76 53 53 13 B5 E8 1C C7 15 15 15 15 
17 17 33 CA B1 27 B2 32 22 DE 6A B5 36 34 34 C0 7D E7 E5 E5 8D 8C 8C 60 36 44 28 14 6A 6E 6E 6E 
6C 6C DC B4 69 13 86 CF C2 0F 8C 8E 8E DE 7C F3 CD 26 93 A9 B7 B7 B7 A3 A3 83 57 DA 46 C3 E1 30 
26 ED 07 83 C1 BA BA BA CD 9B 37 D7 D5 D5 61 F3 22 91 C8 E0 E0 E0 DC B9 73 F3 F3 F3 91 93 C4 73 
73 1C 17 89 44 B6 6D DB 06 0F 0C 1F EE 76 BB 6B 6B 6B 69 71 02 52 02 B0 8B DB B7 6F 7F E2 89 27 
70 07 88 2F A6 0C C3 64 50 B6 16 4E 98 28 45 92 92 24 35 34 34 F8 FD 7E 8C 2D EE EF EF CF C9 C9 
81 AA 5C BC 78 F1 89 27 9E 38 7D FA 34 26 7A 40 67 F0 2B 1A 0F 50 B1 13 94 39 6E 68 19 83 8B 66 
59 B6 B2 B2 D2 62 B1 F8 FD 7E 28 6A 20 10 38 76 EC 58 42 39 7A 0D 22 0E 20 30 30 30 80 D8 1B 06 
15 21 1C 0C D3 D8 B1 63 3D 1E 8F AC CC 1A 1C 1D 1D 3D 7E FC F8 D0 D0 D0 8E 1D 3B 30 5F 93 12 C5 
2C CB 22 2E A5 6D 50 34 C0 1B 19 19 01 EF 8F 20 6D DB B6 6D 10 50 B8 6E C4 05 81 40 A0 AF AF 0F 
79 63 59 39 AB 93 72 DA 58 C9 74 3A 9D 9D 9D 8D D0 B4 AB AB AB A5 A5 E5 ED B7 DF A6 9D A5 82 72 
DC 25 8D AB E1 F7 50 A8 04 AC AE 56 AB 8B 8B 8B 11 D9 82 FD 6E 6D 6D F5 7A BD 4F 3D F5 54 57 57 
17 1C 38 7D 59 5A DF 83 D7 14 95 41 95 92 D2 2F A2 D5 6A 07 06 06 EA EB EB 71 6C A1 28 8A C8 D9 
42 F0 DE 7A EB 2D 98 2A 70 36 D8 38 E4 C9 31 0A 04 3B 08 7E 05 FB 4B 94 32 60 A2 CC 31 E9 EF EF 
CF CA CA 2A 2D 2D E5 94 79 1F 38 2F E3 67 3F FB 59 57 57 17 D0 16 C0 0B 8D 9F B1 7A C0 50 99 A4 
0C 50 A7 DF EF EF E8 E8 A8 AF AF 77 B9 5C DC B5 D7 5E 7B F0 E0 41 36 63 FE 02 CB B2 80 8B 74 64 
10 C4 D7 62 B1 A0 9D 8A 10 92 4C 26 31 F6 1F 65 F2 6D 6D 6D E7 CE 9D 93 95 34 A0 20 08 6E B7 FB 
8E 3B EE C8 CF CF B7 DB ED 6E B7 FB C4 89 13 60 20 04 41 70 3A 9D 38 BB F7 CC 99 33 CD CD CD 80 
A3 8C 72 42 FD 37 BE F1 8D C5 8B 17 E3 B4 5A 9A 08 12 45 F1 C2 85 0B 1F 7D F4 11 AB 74 A0 71 1C 
37 63 C6 8C 9A 9A 1A 6A 6C C0 50 69 B5 DA 3D 7B F6 BC F0 C2 0B D8 24 93 C9 84 62 23 3A 2E 85 51 
6A 11 B1 25 74 2F 59 96 CD CD CD 0D 87 C3 1D 1D 1D 91 48 A4 B2 B2 12 0D 96 1A 8D C6 E7 F3 3D FF 
FC F3 CD CD CD 98 83 4C 94 D3 81 A8 32 67 B2 E1 9C D2 9E 82 A8 46 10 04 10 03 DD DD DD 3C CF 97 
95 95 C1 76 A8 54 2A AF D7 BB 67 CF 1E 92 51 CF 09 6E 50 14 C5 CC 73 B6 65 A5 88 1C 02 11 08 04 
C0 B8 50 4E 45 AB D5 52 7B 4A 13 24 30 FC 30 9D B4 DC 04 04 06 A0 5D 32 99 9C 3B 77 2E 78 91 37 
DE 78 03 E0 19 1E 00 A8 84 28 63 DD 68 30 99 B9 56 50 4E E4 33 11 B6 A4 52 29 D4 87 C0 DE E1 AF 
50 7D 4E 59 0D F0 76 74 BE 73 32 99 1C 1C 1C 5C B7 6E 1D 6E 6E 34 1A 3D 1E 8F CF E7 7B EC B1 C7 
10 9D 22 8F 82 E5 A2 9C 19 5E 93 56 02 F2 CA 71 BD C0 3B B0 E9 17 2F 5E CC CE CE 2E 2A 2A C2 63 
40 F7 DE 7F FF 7D 6A 95 A8 9A A5 32 A6 EC C0 14 22 E4 A1 45 F6 A2 32 FF 16 98 28 54 D2 00 00 20 
00 49 44 41 54 C0 4A 92 A4 C1 C1 C1 39 73 E6 58 AD D6 91 91 11 A4 CA B7 6D DB 76 F4 E8 51 20 70 
3C 15 A5 8E A4 8C 9A 53 44 4F 82 32 90 91 AE 6A 24 12 B1 5A AD D5 D5 D5 2C 4A 6F 21 A3 B0 BE 98 
E1 C5 29 D3 A9 99 8C 61 39 4B 96 2C B9 EB AE BB F0 0E E0 7B 10 E6 D2 32 7C F0 E0 2A 95 EA DB DF 
FE F6 FC F9 F3 71 1A 44 69 69 E9 8F 7F FC E3 DC DC 5C A8 2B 28 50 20 6F 68 3B 85 7C D7 5E 7B 6D 
6D 6D 6D 3A 9D C6 E1 DE E0 7F F1 78 1D 1D 1D 44 39 C3 0C 72 3F 6E DC 38 6A B3 C1 E2 98 CD E6 86 
86 86 3F FC E1 0F 08 24 10 5C A1 2D 83 2E 10 6C 6D 26 A9 0D A9 62 18 A6 BF BF 1F F2 BA 7F FF FE 
DD BB 77 C3 8E 86 42 A1 DF FF FE F7 8D 8D 8D 88 7B C1 F1 C2 E6 81 6C C4 2A 71 4A E9 33 48 08 5E 
29 2B C3 F6 60 31 5F 78 E1 85 F3 E7 CF 03 84 4B CA 69 90 99 FD BB 60 32 34 CA 34 57 A2 D4 9D 60 
C3 C0 1C E8 74 3A 4C 73 04 F6 46 92 03 B0 0A 18 8C 1A 1A AC 12 4A 6D 88 42 7D 41 CF 0D 06 03 28 
0D 18 0B FA 45 20 39 44 51 84 53 82 ED 03 3E A4 B9 4A EC 1A A8 CE 94 72 01 F4 72 1C 87 CD E5 95 
D3 C1 30 64 90 E7 79 8A 93 01 73 90 21 30 99 4C 5E AF B7 BE BE 1E 9C 36 4A BB 9E 7B EE 39 88 B5 
56 AB 45 49 03 42 D6 CC 5A 7F 1A 48 C7 62 31 70 16 80 CD 30 43 56 AB D5 EB F5 BE F2 CA 2B DD DD 
DD 66 B3 19 1E 18 36 48 50 CE A5 83 54 C7 E3 71 5A DF A2 52 A9 28 A5 8C 83 90 29 01 43 25 04 EB 
83 89 CC B1 58 CC 66 B3 F1 3C DF DC DC BC 6D DB 36 AA 44 84 10 3C 15 0D 85 70 51 49 86 C4 E2 5B 
00 E6 0D 06 C3 F5 D7 5F 3F 7D FA 74 DE 64 32 95 94 94 74 75 75 49 CA 10 BB 68 34 7A EE DC B9 AA 
AA 2A B3 D9 8C 72 24 40 14 6C FF 8A 15 2B 2C 16 CB CE 9D 3B 1B 1A 1A 10 C5 4A 4A 27 2B 80 C1 AC 
59 B3 96 2F 5F 5E 5E 5E 4E 29 0D 41 10 C6 8F 1F 7F DF 7D F7 ED DD BB F7 E8 D1 A3 90 1E 88 32 51 
EA 7B 26 4C 98 B0 6A D5 2A 1C 04 0F B0 44 A1 0E 22 99 03 07 0E 70 4A B7 3B 3C F0 8C 19 33 24 A5 
AA 50 14 45 D8 AA E7 9F 7F 1E 8C 54 3A 9D 36 99 4C A3 A3 A3 08 74 21 73 85 85 85 13 26 4C C8 CB 
CB 33 99 4C 6D 6D 6D 38 22 52 52 BA CE B1 34 00 36 BB 76 ED AA AA AA 9A 38 71 E2 9F FF FC 67 8C 
78 C0 1D 28 E9 02 4B 64 30 18 26 4F 9E 5C 5A 5A 8A 40 22 10 08 9C 3C 79 12 9D EC 30 F6 E0 C7 D3 
4A 47 D5 1F FE F0 87 C7 1E 7B 0C 31 3D 36 0F 74 14 64 17 4B 0D 04 48 08 01 2B E8 70 38 82 C1 60 
67 67 27 CC 6A 3A E3 2C 0D BA CD F0 C3 48 C1 15 16 16 96 96 96 06 83 C1 B3 67 CF 22 F1 08 73 00 
D9 C2 16 83 B4 EC ED ED 1D 3F 7E 7C 52 99 0C 86 ED A0 A1 26 42 DF 70 38 8C 26 9B CA CA 4A 64 08 
70 12 23 72 A7 58 37 8B C5 82 3E 2F FC 1C 07 F2 61 38 25 52 4A 88 B4 D1 6F 80 8F 21 ED 04 C0 D2 
DE DE 3E 69 D2 24 9E E7 C3 E1 F0 2B AF BC 02 2A 18 09 18 95 D2 93 09 51 76 3A 9D 13 27 4E CC CF 
CF C7 CC C1 8E 8E 8E 86 86 06 B4 ED C3 31 F2 CA 34 3A 42 C8 E0 E0 E0 73 CF 3D F7 D8 63 8F C1 21 
63 66 05 D8 5D 90 D8 82 72 4C 20 1A DC 19 86 29 2E 2E 06 09 82 E9 5E 88 29 52 CA 89 EE B8 2D 3D 
BD 03 CD 15 A2 28 A2 ED 16 D0 06 68 02 EB 69 B3 D9 6E B9 E5 96 49 93 26 C1 D6 0C 0F 0F 37 35 35 
D5 D7 D7 B7 B6 B6 E2 24 42 6C 19 6A 89 C7 8D 1B 97 4C 26 79 41 10 66 CE 9C D9 DE DE 4E 94 73 42 
05 41 38 74 E8 D0 82 05 0B 7A 7A 7A C0 4A 49 4A CD 2A B2 76 33 67 CE 9C 32 65 4A 4F 4F CF B9 73 
E7 80 EB 38 8E 33 9B CD C5 C5 C5 13 26 4C 28 28 28 C0 4B C2 30 C3 A2 30 0C 53 56 56 36 6E DC B8 
35 6B D6 34 36 36 76 76 76 86 42 21 08 47 51 51 51 4D 4D CD D8 B1 63 35 CA 01 72 34 5A 40 53 5F 
4F 4F 4F 2A 95 C2 1C 0A D0 18 7A BD 1E EC 30 0C 5B 5A E9 5A 3E 72 E4 08 AC A9 2C CB 46 A3 11 A5 
CF 40 26 7A BD 7E D9 B2 65 AB 57 AF 76 3A 9D C8 34 2E 5C B8 F0 A6 9B 6E DA B6 6D DB 7B EF BD 47 
2D 2E 5C 47 4D 4D CD BC 79 F3 66 CC 98 D1 DC DC 7C F4 E8 51 0A 5A E8 34 17 7C 69 6D 6D 6D 6D 6D 
6D 6E 6E 2E 3C 21 96 6E FD FA F5 7B F7 EE 7D E7 9D 77 C2 E1 70 34 1A C5 A9 3E AC 72 66 5B 20 10 
38 7A F4 E8 B2 65 CB 32 41 38 0C 0A AC 26 96 9A E7 F9 A5 4B 97 2E 5E BC B8 BC BC 1C 8A 1A 8F C7 
0F 1D 3A F4 DC 73 CF 91 CB 5C C9 64 72 EC D8 B1 77 DD 75 D7 A4 49 93 5A 5A 5A 40 3E BD F4 D2 4B 
87 0E 1D 82 D8 71 4A B5 AD A8 9C 3C 2D 2B 9D C4 99 26 1C 1F 46 F0 19 0E 87 27 4F 9E 7C DD 75 D7 
55 55 55 81 D9 92 24 09 B4 21 74 06 36 1E B2 45 8F 5B AF AC AC 5C B9 72 E5 EC D9 B3 39 65 B4 FE 
F1 E3 C7 5F 7A E9 25 B8 FD 64 C6 70 44 1A 6C E3 1F 67 CF 9E ED EB EB 03 09 8C 0F B0 4A 99 3E 21 
64 F5 EA D5 1B 37 6E 04 32 87 99 36 9B CD 17 2F 5E FC E4 93 4F DE 7A EB 2D 8C 83 C1 E7 A1 30 2C 
CB F6 F5 F5 9D 3C 79 72 E2 C4 89 9F 53 3D 82 52 84 09 13 26 AC 5B B7 0E C7 3F C2 56 EE D9 B3 67 
EF DE BD 18 0B 46 F3 93 D0 76 2A DE C8 B1 ED DC B9 93 1E C7 04 6C 82 D5 7B F8 E1 87 51 7B 08 4F 
66 B7 DB 57 AC 58 B1 66 CD 9A D6 D6 D6 D3 A7 4F BF F1 C6 1B 78 80 4D 9B 36 D1 54 22 CF 30 CC EC 
D9 B3 5F 7B ED 35 A0 58 BC F9 89 13 27 3A 3B 3B 91 AC E3 32 FA AD F0 5F 38 F4 FC FC 7C 8C 2D 41 
CC 40 7B FC D2 19 8D F0 99 05 13 C8 0B DB ED F6 45 8B 16 2D 59 B2 44 C8 38 7B 04 42 09 EA 2C 95 
4A 51 3A 1E 07 12 3A 9D CE 4D 9B 36 41 9A 81 6C 63 B1 D8 8A 15 2B 00 1E 68 58 9B 4E A7 F7 EC D9 
83 01 CD 44 29 DF C1 E1 D8 1C C7 5D 73 CD 35 2B 57 AE CC CF CF F7 F9 7C A0 E9 E1 C9 6F BD F5 56 
97 CB F5 CC 33 CF C0 D6 8C 1B 37 EE 86 1B 6E 98 3E 7D 7A 20 10 40 93 7E 4F 4F 0F C4 2E 93 A9 97 
65 79 E6 CC 99 8B 17 2F 9E 30 61 02 86 C1 D2 E8 22 27 27 67 C5 8A 15 39 39 39 CF 3D F7 1C A8 2C 
64 6B E0 24 23 91 C8 BE 7D FB 16 2E 5C C8 2B C7 87 10 25 3E E4 94 DE 14 42 48 41 41 C1 86 0D 1B 
E0 94 70 2E 90 DB ED 9E 32 65 CA B4 69 D3 70 78 F3 67 2F B5 5A FD F0 C3 0F E7 E6 E6 0E 0C 0C 8C 
1F 3F 5E 14 45 9F CF F7 BD EF 7D AF BD BD 1D 79 29 4E 99 10 2F 67 1C 07 40 D5 92 DE 07 D5 14 60 
59 74 3A DD 2D B7 DC 32 6E DC 38 49 92 50 2D C8 B2 EC C2 85 0B 2F 5C B8 30 34 34 04 4B 87 BF 42 
71 0F 10 CD 35 D7 5C 83 93 4F 61 F5 9C 4E E7 DC B9 73 F7 ED DB 87 E4 5B E6 33 D3 A8 01 4F F2 F1 
C7 1F 53 25 A7 8A 0A 00 BC 7E FD FA F5 EB D7 A3 EE 17 47 33 41 43 8A 8A 8A B2 B2 B2 92 C9 24 26 
1B 01 05 08 4A 7F F3 C8 C8 C8 DE BD 7B 27 4D 9A 74 39 55 24 84 A0 94 A2 B6 B6 76 F2 E4 C9 48 71 
C3 85 D6 D6 D6 8A A2 D8 D2 D2 22 29 8D 5D 10 3F 3C 33 EC 32 FE 31 3A 3A 6A 34 1A 51 BC 09 DA 1C 
36 2E 3F 3F 1F 63 60 C1 FA 42 8F 92 C9 64 61 61 E1 98 31 63 A6 4C 99 F2 EC B3 CF 7E E3 1B DF 90 
65 19 B3 7C 62 B1 D8 5F 67 0D 97 96 96 8A CA FC 66 A0 B5 37 DF 7C 33 2B 2B 0B 6E 9A 51 C6 96 32 
0C 83 24 3E 0D DE 40 16 E1 04 12 95 32 1D 88 46 ED 70 29 34 A3 00 EC 4A 33 DD B0 3A 20 9A E8 45 
F3 81 92 D2 96 1E 8D 46 3F FA E8 23 08 13 EA 57 08 21 60 20 92 CA F9 C1 0C C3 0C 0C 0C B4 B5 B5 
C9 4A 15 1E 20 3E C4 C5 ED 76 AF 5D BB D6 6E B7 F7 F6 F6 22 6E 49 24 12 A1 50 68 60 60 40 AB D5 
CE 9D 3B 77 C9 92 25 66 B3 F9 C7 3F FE F1 53 4F 3D 35 65 CA 14 D4 A0 A9 D5 EA 23 47 8E C0 FE 41 
B0 A8 0C 99 4C A6 6F 7F FB DB C8 85 A0 B0 01 E1 99 D9 6C F6 7A BD A8 DE 9C 39 73 26 5E 90 E7 79 
9C 1E 81 45 6B 6B 6B C3 41 4B 6C 46 D1 39 BC 16 54 45 AB D5 4E 9D 3A 15 04 86 28 8A D9 D9 D9 56 
AB 15 B6 69 E6 CC 99 97 93 AA 55 AB 56 21 95 AF D7 EB BB BB BB 7B 7B 7B 31 F8 67 F2 E4 C9 10 6E 
51 A9 C6 24 CA 90 9E CF AA 22 21 84 A6 8E 45 51 CC CB CB 1B 3B 76 6C 2A 95 C2 D4 5C 1C F8 A3 D5 
6A A7 4F 9F 8E D2 1C D8 62 24 8D 40 21 96 95 95 4D 9A 34 09 78 44 92 24 78 8C FC FC 7C AC 3F 0D 
3E 33 BD 22 3E 19 8D 46 81 81 71 41 6F 01 29 F3 F3 F3 57 AC 58 A1 D3 E9 86 87 87 31 6C 09 CA 80 
A1 21 2E 97 6B FD FA F5 15 15 15 88 03 A9 5F 85 FC D4 D7 D7 E3 04 BE CB AD 1B C3 30 35 35 35 8B 
17 2F A6 E3 88 08 21 00 AE 35 35 35 A0 6D 28 A7 2D 64 1C 44 8B 00 C1 E7 F3 39 1C 0E 2C 0E 7A 68 
F1 3A 26 93 E9 CD 37 DF 44 61 0C 14 8A 28 13 2B 11 12 17 17 17 FF E2 17 BF 18 37 6E 9C CD 66 4B 
26 93 3D 3D 3D A8 0C 65 09 21 B0 04 F0 4B 30 30 47 8E 1C 39 7B F6 2C 6A 94 F9 8C 59 43 68 FC 81 
02 20 D4 21 CA A4 20 42 88 5E AF 47 35 36 51 02 56 46 39 0B 41 AD 56 A3 7F 07 10 94 4E 22 11 94 
49 61 D0 10 68 35 DE 76 74 74 D4 E5 72 BD F4 D2 4B 34 F6 05 CF 51 56 56 36 76 EC 58 68 1A A5 AA 
1B 1B 1B 25 A5 37 1A 7B 89 F4 06 C7 71 33 67 CE 44 E7 0E 8C 10 CE 1B D7 EB F5 2E 97 0B 93 AC 36 
6E DC F8 F4 D3 4F 4F 99 32 C5 EF F7 27 12 09 74 3F 0C 0C 0C F4 F4 F4 50 B0 04 88 82 17 99 3A 75 
2A E8 69 0C 13 C0 86 61 F5 50 43 13 89 44 D6 AD 5B 07 27 4C 29 10 CA AC 9C 39 73 46 52 E6 05 52 
F3 41 69 6D 96 65 CB CB CB E9 CF 63 B1 D8 E8 E8 28 56 0C 93 32 2E 79 15 14 14 80 58 56 AB D5 48 
15 02 B0 94 97 97 D3 34 15 DD 8B 4F 41 C4 4C 85 C4 E6 82 54 2C 2E 2E 46 66 C2 6A B5 E2 38 7A 44 
13 25 25 25 28 BC D4 2A 47 77 86 42 21 B4 29 E6 E4 E4 C0 DE 21 3A 00 37 EE F3 F9 4A 4A 4A 46 46 
46 52 FF 71 5A B4 AC 5C 84 90 EE EE EE E1 E1 61 56 29 A6 A7 39 58 51 14 57 AD 5A 95 9D 9D DD DF 
DF 8F FA 35 E4 96 45 51 74 3A 9D 38 AC 49 AB D5 D6 D6 D6 12 A5 C8 16 41 32 CA 18 62 B1 58 67 67 
E7 A7 2C CE A7 2E 95 4A E5 F7 FB 51 11 89 78 04 F9 43 BB DD 9E 39 50 97 EA 92 9C 71 2C 34 58 1F 
44 46 10 1B 42 08 F4 E2 AD B7 DE FA E3 1F FF F8 CA 2B AF 34 35 35 51 11 82 CB C9 3C A9 21 9D 4E 
87 42 A1 E2 E2 E2 A6 A6 A6 BF B2 08 73 E6 CC C9 CF CF 27 0A 3D 80 3F 7E F1 C5 17 C1 22 22 EC 81 
EB 73 BB DD 28 68 A6 3E 13 8C 9F CD 66 63 18 26 18 0C 62 C0 94 4A 39 C0 04 E6 0A 4E 0F 29 6F B0 
5E B0 C1 78 A6 68 34 8A 70 B6 A0 A0 20 12 89 20 EC 26 84 20 35 B2 77 EF 5E 54 87 D0 5E 87 AF 7D 
ED 6B 48 0A A1 2E 04 D6 A8 A9 A9 09 B5 A3 D8 60 50 9A D8 D1 F9 F3 E7 D3 EA BF 40 20 40 4F C8 80 
F3 B1 5A AD 0E 87 43 A3 D1 68 34 1A AB D5 8A FA D8 70 38 4C EB 24 53 19 23 BA F1 5D B3 67 CF 86 
5A 22 83 42 D5 0C C3 20 54 2A 95 DD 6E CF CB CB 03 EA 23 19 67 2A C2 43 E2 D0 42 7A 43 D8 5D 6A 
B9 C0 4B A7 95 5E 24 B4 11 52 86 F6 72 22 65 B1 58 50 BD 4D 47 45 43 5B 30 DF 84 64 1C 67 C4 28 
05 49 74 BB 33 39 21 38 73 7C 51 71 71 31 02 F5 60 30 08 40 81 6A 64 04 ED 92 32 A2 1F 7F 48 87 
77 B1 CA 60 6F C8 1C 4A 20 21 5D A8 C4 B8 E4 D5 DC DC 2C 29 E9 65 4A 3F E2 BF 93 26 4D 62 18 C6 
E1 70 48 92 04 FB 28 28 ED 3E 3E 9F 0F B6 60 C1 82 05 1A 65 5A 2F 85 1B D0 0D 0C EF BB DC F7 AA 
D5 EA B1 63 C7 C2 2F 41 99 21 1E 88 F7 24 A5 A2 03 F4 21 C9 A8 82 00 E8 73 38 1C 48 2E 44 22 91 
50 28 44 E3 29 A4 43 CE 9F 3F FF EE BB EF 3E F6 D8 63 B7 DF 7E FB 0F 7F F8 C3 CD 9B 37 1F 3F 7E 
DC E3 F1 20 B1 11 08 04 50 7A 89 D3 34 CA CA CA FE 3A AE 4B AB D5 AE 59 B3 06 13 A8 44 A5 15 FD 
C2 85 0B 3B 76 EC 98 37 6F 1E 0E AB 40 1A AD AF AF 0F C0 0C 36 4C 50 E6 CC 82 80 82 D1 A2 89 66 
08 9C AC 4C CA 41 A0 9F 4C 26 71 DC 12 25 48 E9 61 01 48 E0 50 FC E9 F3 F9 30 8C 88 66 50 18 86 
A9 AE AE AE A9 A9 41 BA 89 51 CE 09 65 18 66 68 68 88 D6 AC D2 B7 C0 F6 E4 E4 E4 E0 C3 3E 9F 0F 
B4 10 CB B2 C8 7D D3 83 84 09 21 88 19 68 BC 8E A3 8B 20 1C 4C 46 9B 8B 28 8A E3 C6 8D 63 95 93 
AE 81 30 69 06 5F 54 86 A0 8D 8C 8C 4C 9D 3A 75 F7 EE DD 28 58 C1 DE C3 AE A1 59 94 CA 31 93 31 
58 91 FE 03 85 57 C1 60 10 5E 02 FB 87 93 95 2E 79 01 D1 98 CD 66 7A 42 16 BE 94 C6 F3 D4 25 52 
29 A7 57 E6 7D 28 A6 22 84 04 83 41 0C 4F 30 9B CD 81 40 00 E0 08 42 0F DA 10 7C 09 A2 29 80 34 
94 D7 E3 15 00 EF 45 65 4A 20 DD 47 A2 F8 E7 CC 27 C1 F8 0F 78 36 FA 30 0C C3 14 15 15 81 0A CA 
C9 C9 41 FF BE CD 66 F3 7A BD 76 BB 1D 59 04 AB D5 0A 53 8E F3 79 49 06 06 01 6D 81 C9 5A 97 BB 
90 18 03 4E C1 EB 80 25 32 18 0C 28 B1 94 95 8A 0E 92 31 7F 9D 55 0E 63 35 18 0C 35 35 35 4D 4D 
4D 30 40 94 F6 A7 1C 32 D5 CF 60 30 B8 7F FF FE 0F 3F FC 90 61 98 DC DC DC 9A 9A 9A F1 E3 C7 CB 
B2 5C 5C 5C 1C 08 04 62 B1 58 7E 7E 3E 8B B5 F0 FB FD AB 56 AD CA C9 C9 A1 B2 08 D6 E1 F5 D7 5F 
0F 04 02 90 72 A4 19 1D 0E 07 C2 DC 70 38 4C FB 65 61 D5 A0 51 18 91 06 50 27 67 64 DB 81 EB C0 
97 42 B1 F1 5D A2 52 E1 C9 F3 BC D1 68 74 BB DD 83 83 83 48 76 BF FC F2 CB 1D 1D 1D 28 8D C7 97 
72 1C B7 7C F9 72 EC 22 5A 2E A0 3F 60 A5 A8 D1 E2 94 8E 4A 41 10 10 E5 63 63 4C 26 13 F6 95 E3 
B8 E1 E1 61 B3 D9 8C B1 31 AC 72 94 1A A7 F4 4C C0 8B A6 32 1A 88 71 7F F4 52 38 9D 4E B8 6B BC 
8B 24 49 58 0D 6C 12 52 82 66 B3 19 E7 DB 44 A3 51 8C 6C E1 32 C6 A8 51 07 C5 29 83 46 61 53 20 
16 D0 25 BD 5E 0F 3C 4C 05 3A 75 F9 73 41 74 3A 1D 4E 6B A7 A9 0E 84 0C B8 21 AD FC 24 4A B7 E1 
67 F5 30 F3 C2 37 AA D5 6A B4 23 D3 03 4F C1 1E 0F 0C 0C 00 34 81 2F A0 E9 7E A2 44 1C 20 D5 00 
37 F0 2B B4 6B 7E 8A C5 C9 B4 08 14 BC C9 CA 74 63 51 A9 39 B1 DB ED 18 A4 80 BA A5 BE BE 3E 64 
B0 30 77 17 C2 E3 F3 F9 50 1F C3 2A 87 B4 C3 AC F3 3C 8F AE B4 CB BD 29 98 9B A1 A1 21 84 48 6A 
B5 1A C2 89 B6 21 0C 55 A1 5C 06 FD 2B CA AB A7 52 A9 0D 1B 36 48 CA 01 5E B4 F8 86 65 59 34 91 
F2 CA 50 2C 4C DC 02 9D D3 DF DF BF 63 C7 8E A7 9F 7E FA D1 47 1F DD BE 7D 3B 9A E3 FD 7E FF 5F 
1B 31 31 DC F2 9B DF FC 26 F2 CE B2 2C 63 FB E3 F1 F8 23 8F 3C 02 44 17 08 04 C0 9B A3 62 98 96 
07 50 5B 48 19 02 4A A6 53 37 45 37 92 C9 18 62 0D 93 03 DB 4F 94 69 91 30 C6 E9 74 7A C7 8E 1D 
87 0F 1F C6 33 20 98 96 24 69 F2 E4 C9 CB 96 2D 63 94 93 12 25 49 42 76 0B 29 10 5A AC 44 45 0D 
1A 8E D4 3F A4 C4 60 30 00 2D 23 A2 23 0A C4 82 1A A3 0F 1D 01 27 80 31 BA 01 29 EC 41 D0 42 3B 
7A 00 0E 51 CA 8C D4 0B 2A BC 30 89 2C A5 9C 88 84 BA 4A 51 19 E3 8B 18 1B BF 12 33 E6 E5 50 AC 
01 0E 13 DA 8E C7 A0 A4 EB 67 B5 08 3F 49 A5 52 C0 D8 52 C6 89 C2 14 91 8A 4A BB 1D 51 68 55 39 
63 80 88 A4 0C 6B A2 F7 47 DC 25 2A E5 23 B0 26 B8 92 C9 A4 C3 E1 20 4A F3 01 75 1A AC 72 DE 30 
3E 06 30 82 E4 10 AB 8C B4 C9 A4 91 49 46 DC 08 06 48 10 04 68 2C 75 E3 AC 32 50 83 F6 46 E1 DB 
D3 4A A3 39 DC 06 44 1C DA 02 51 C1 6A D3 FE A4 CF 61 71 24 49 02 35 88 3D 05 05 80 EF 82 C1 A5 
66 9A 66 01 50 66 A0 56 0E FC 2C 29 29 F9 CE 77 BE 23 8A 22 F8 45 95 4A 85 26 66 80 FC 4C 53 45 
6D 13 92 9F A9 54 0A 07 E3 3E FD F4 D3 F8 52 56 AB D5 0E 0D 0D 21 D2 9B 30 61 C2 D5 57 5F 4D DD 
34 B6 36 95 4A DD 7F FF FD 18 B5 82 33 8F B1 46 60 75 91 5F D6 5E F9 E9 31 78 37 8B C5 82 89 A3 
08 FA 21 AF 1C C7 9D 39 73 66 CB 96 2D 90 5A 9A 68 CE CD CD BD ED B6 DB FA FB FB CD 66 33 96 9E 
22 61 50 BB AC D2 B8 2D 29 07 A7 82 67 87 C2 30 0C 03 83 97 D9 01 88 D7 64 94 04 3D 8E 67 85 49 
42 0D 07 A3 64 1D A8 5D 07 5B 83 F6 5C 8A 87 B5 5A 2D 0A 77 B0 0D 40 AD 10 1A 9A 6B CE 94 00 BA 
08 57 BA 6E FF BF 5E 74 29 64 25 DF C3 2A 07 36 27 12 89 EC EC 6C 4A 6C A2 4A 9B 53 BA FE 1D 0E 
07 EA 04 68 FD 30 93 71 54 19 F9 8F 95 49 FF F5 8B 0A 55 4A E9 11 D7 EB F5 F3 E7 CF 7F FC F1 C7 
D1 FA 08 92 12 67 4C 80 49 A2 E2 41 C9 0B 68 16 7C 43 3A 9D AE AF AF 7F EE B9 E7 BC 5E EF 5F E3 
54 94 0E 69 34 9A B5 6B D7 16 17 17 63 46 10 C2 3C 94 98 3C F3 CC 33 ED ED ED 76 BB 1D A7 56 11 
42 40 91 C1 09 20 69 7E 45 17 A3 B4 32 42 99 91 C9 40 D9 E4 81 03 07 9E 78 E2 09 9B CD 46 14 A3 
AE 52 A9 74 3A DD C6 8D 1B 73 73 73 D1 A8 4E 81 28 DD 33 54 1A 10 C5 3A 4A 0A 77 8F FA 55 5A D6 
48 1D 02 51 F2 BC B8 60 D2 74 3A DD D0 D0 10 E6 09 E0 26 9C 32 82 5D CC 68 B4 25 CA 91 BA B0 A6 
99 47 A6 23 66 83 10 D0 83 C7 68 F8 81 FF E5 32 5A 3D FE CB E2 F1 FF C9 A5 FA 8F 07 D1 D0 F5 41 
72 88 42 74 BA DD D8 0B E0 64 40 5C 60 25 51 A9 9D A4 D5 82 34 7B F9 85 5C 29 65 82 2E 68 79 59 
96 BD 5E 6F 3A 9D 2E 2F 2F 7F E3 8D 37 BE FB DD EF 56 54 54 A8 D5 EA 9E 9E 1E 20 2F 49 39 B7 87 
BA 47 9D 4E 47 E5 13 42 25 CB F2 E1 C3 87 3D 1E 0F 2F 49 12 DA 02 25 49 1A 1D 1D CD CB CB BB E3 
8E 3B 9E 78 E2 09 9F CF 47 14 BF 24 8A E2 D9 B3 67 DB DA DA 1E 7E F8 E1 82 82 02 38 31 2C 07 DC 
97 DD 6E CF 9C FC F5 B7 5C 68 AD 10 95 61 9E 48 9B E2 14 A7 AD 5B B7 A2 D4 5B A3 D1 60 FA 03 C7 
71 2B 57 AE 9C 33 67 4E 20 10 C8 CE CE 46 8B 2A 0A 20 69 71 42 56 56 16 D8 11 9A 5F 01 C4 05 CF 
89 42 10 94 47 CA B2 8C 5F 81 AF 97 94 09 45 C3 C3 C3 84 90 FF DB DE B9 C5 46 55 76 7D FC 99 43 
3B ED 4C 4B CB CC D0 03 6D 29 2D B4 50 04 DB 0A 16 04 29 12 23 89 10 B8 90 26 92 20 01 BD 10 41 
AB 78 A3 09 44 8C 22 11 88 A1 28 41 23 79 25 98 88 A1 0A 1A 13 50 D4 58 C4 72 68 6C 89 1C 5A 0B 
34 86 0E 74 DA 69 87 96 69 CB 4C 4F B3 67 7F 17 3F 9F 95 C9 AB 35 9F F9 BC FA DE 77 5F 10 A0 9D 
3D FB B0 9E F5 AC F5 5F FF F5 5F A0 F9 E1 70 18 C0 7A 38 4E 53 94 77 3F 36 36 46 B3 88 45 33 83 
E9 4E 20 D1 32 B5 42 24 F9 15 61 B0 A0 B2 FC 85 D6 8A BF 48 66 FE 03 0F C0 58 09 53 85 1D D5 D5 
D5 E5 70 38 E8 CE 03 CA A2 E4 48 19 26 AA 27 4C 2A A5 68 04 57 BA CE 61 68 05 50 8F C7 63 FD CB 
E1 76 7F EB 90 10 9A 56 7B B7 DB 4D F1 09 F4 A1 AC AC AC B4 B4 D4 6A B5 B6 B5 B5 9D 3D 7B B6 A3 
A3 03 EA 45 2C 4E E6 C6 34 4D 0C 49 69 5D A5 D4 D4 D4 50 28 D4 D2 D2 62 25 BD 61 4B 4D 49 49 09 
85 42 15 15 15 6B D7 AE A5 A7 F3 DE BD 7B 0C C7 25 7F D8 B1 63 C7 95 2B 57 42 A1 10 C9 3A A1 26 
59 FE DF BD 2B 86 34 E1 D8 90 FF 08 06 83 EF BC F3 CE C7 1F 7F 4C 70 A2 94 4A 4C 4C EC ED ED 75 
3A 9D 15 15 15 AB 57 AF A6 A3 8C 29 0B 10 CA 85 5A 60 9A 26 3A A8 72 7E 7B DC 2C 9A 96 96 16 66 
47 13 D2 48 4A 29 70 B6 CD 66 83 BB C4 1A EB ED ED 55 4A CD 9E 3D 1B CC 49 C5 0D BE C7 07 B7 B4 
B4 B0 E4 C0 4B 04 0D 97 85 C7 EB A7 61 3F 3E 5F E2 C8 CD CD 35 E3 C6 CE FC F7 50 4A A1 FC 40 9E 
26 B8 03 99 7C 47 47 87 D4 BD C1 ED 0C C3 A0 83 1C E9 13 4A 1D 50 3B 94 AE 6D 48 66 91 97 97 F7 
0F 5E 27 8E 9B F7 1B DF 90 81 76 0C 96 E9 74 3A 67 CC 98 B1 6E DD BA 3D 7B F6 EC DF BF BF A6 A6 
E6 B9 E7 9E 5B B4 68 11 8A 75 24 38 66 9C 4E 1A 58 6E 7D 7D FD EF B3 34 90 15 A0 1D 26 14 0A 2D 
5D BA F4 A5 97 5E 22 F4 42 32 10 89 D4 FE FE FE 9D 3B 77 1E 3B 76 AC BB BB 9B 6D 9A EA F9 5F D4 
91 C6 3B 86 87 87 0B 0A 0A 4C D3 BC 7B F7 6E 42 42 C2 D7 5F 7F FD C6 1B 6F 34 36 36 CA 5E 97 99 
99 89 D7 99 35 6B D6 A6 4D 9B E2 85 5E 6D 36 1B 79 2C A6 8F AD 53 75 50 5A 7C 8D 6A 1B 5B 77 7D 
7D 7D 4A 4A 0A B9 B5 C4 99 C4 F1 4A 29 FE FF D4 A9 53 6D 6D 6D A4 F2 FC 02 A1 7F 3C DE 10 D5 E2 
FF 0D 0D 0D 89 89 89 14 8B 86 B5 E8 B8 D2 B2 57 90 C8 DA DB DB 91 8D 96 6D D0 D0 D2 E6 25 25 25 
4A 67 38 FF 88 89 FC 3F 38 A6 4C 99 22 F0 B5 25 8E A7 6A B1 58 4E 9F 3E 4D DE 88 6D 08 6B 6F 60 
60 80 F0 CA EB F5 D6 D5 D5 29 ED 82 C9 5F 94 AE 88 4E 9B 36 ED DF B0 DC FF CB 21 19 10 B9 2B 75 
9D 68 34 1A 08 04 A0 5E 73 80 66 C3 4C C8 CD CD 5D BA 74 E9 0B 2F BC B0 6B D7 AE 6D DB B6 95 97 
97 0B 2F 4A 20 09 BB DD DE D5 D5 F5 7B 14 2E F5 09 42 3B A5 D4 82 05 0B D6 AD 5B A7 34 D3 9C 2A 
36 EC 87 2F BF FC 72 FB F6 ED 67 CE 9C E1 B3 12 C8 FD AD C3 ED 76 CB 4C B5 7D FB F6 1D 38 70 80 
B5 27 05 CC EE EE EE 09 13 26 CC 9A 35 6B F3 E6 CD 60 2A 6E B7 BB A7 A7 87 F8 84 E2 8A EC 30 36 
9B 8D 01 63 4A 77 21 98 7A 56 9C DD 6E BF 7C F9 F2 C5 8B 17 71 45 51 DD AE C1 C7 69 69 6B 68 68 
38 72 E4 C8 9B 6F BE 79 E8 D0 21 9F CF 27 1A 6A 95 95 95 4A 6F B0 4A 23 0D 56 AB F5 EA D5 AB 57 
AF 5E C5 07 03 84 1A BA 33 95 00 BE B3 B3 F3 E4 C9 93 F1 F5 34 A5 55 E8 93 92 92 4A 4B 4B D9 99 
FF 1B AC CA 51 50 50 E0 F1 78 2C 71 C3 EA 04 FA 42 D3 C0 A2 BB F0 F8 4F 1A 26 80 00 AF 5F BF FE 
E3 8F 3F 8A 5C 5D 4C 6B 67 98 A6 99 9D 9D 3D 75 EA D4 7F 30 0C 81 9F 00 3B CF 30 0C 97 CB 95 9D 
9D 3D 3A 3A FA D3 4F 3F 6D DE BC B9 B9 B9 99 8E 39 3C 75 5A 5A 1A 73 D6 A0 2E 25 27 27 2F 58 B0 
60 C9 92 25 0E 2D C3 67 68 21 18 DA E8 AC 4E A7 73 68 68 08 AD 5B 10 0E B4 F4 A2 D1 E8 C2 85 0B 
5F 7F FD F5 91 38 65 C1 3B 77 EE D0 A1 13 0C 06 DF 7D F7 DD 2D 5B B6 D0 07 38 16 A7 F8 F0 BF 3C 
90 A0 7D EF BD F7 36 6E DC 78 E1 C2 05 C9 AF 2C 16 8B 04 93 65 65 65 DB B6 6D 23 1F 4B 4A 4A A2 
80 43 88 92 92 92 D2 DD DD CD 3D 2B A5 AC 56 2B 3A F3 36 2D A4 0B 1A AE 94 A2 10 FF D9 67 9F C1 
62 13 F7 29 00 97 DF EF 3F 7E FC 38 69 F3 F7 DF 7F FF CA 2B AF 1C 3C 78 10 AA 2A 2D 94 82 BE 70 
5A 48 76 47 8F 1E F5 F9 7C 5C 18 5F 4A EC 4A D1 E5 DA B5 6B A7 4F 9F 4E D2 C3 80 C5 61 01 47 4D 
9D 3A 15 F7 17 5F C2 FA 0F 3F B2 B2 B2 BC 5E 2F A5 94 58 DC 14 9D 68 34 DA D5 D5 75 EA D4 29 D8 
97 0C 68 81 A9 9F 96 96 C6 7C E2 4F 3F FD B4 AF AF 8F 88 11 DC 15 D3 57 4A 65 66 66 C2 1C FA A7 
0E 16 82 84 42 D1 68 B4 AD AD ED E0 C1 83 47 8E 1C 19 1A 1A FA F0 C3 0F 4F 9C 38 41 35 9B 64 12 
D0 DE E3 F1 B8 5C 2E BA 79 BC 5E 2F AD AA 4A 29 EC 67 68 68 E8 77 C5 50 5A 45 B1 75 A9 87 50 5D 
4D 4B 4B 9B 3B 77 EE F6 ED DB 67 CE 9C C9 75 50 79 C3 8C EC 76 7B 20 10 F8 E8 A3 8F 5E 7D F5 D5 
DD BB 77 37 35 35 21 E8 44 0E 2D BF 23 D1 05 69 5E 24 12 F9 E5 97 5F 6A 6B 6B 9F 7F FE F9 AD 5B 
B7 9E 3B 77 8E C2 0E 1F 01 D8 A4 70 BC 76 ED DA 0D 1B 36 60 BE C0 C4 14 1B E0 AF 73 79 22 94 CE 
C9 57 AD 5A 45 E0 AE 34 81 10 3C CD 62 B1 34 37 37 EF DD BB 37 BE C7 CA 6A B5 A6 A4 A4 B4 B6 B6 
FE EB 5F FF A2 95 19 BD AC 58 2C 76 F2 E4 C9 AD 5B B7 76 74 74 D0 29 C2 83 03 B6 35 4D 93 FE 4C 
86 93 D7 D7 D7 F3 45 94 D7 28 22 1D 3E 7C F8 D0 A1 43 36 AD 4A 24 C8 04 E5 7B C6 9C 44 A3 51 E6 
0B 48 47 35 35 5E C3 30 24 40 F8 B7 84 33 16 A7 C3 FB C7 43 E9 A2 9F 20 19 16 3D 62 2C 41 AB 25 
98 BA 0B 47 B2 6E DE 75 2C 16 23 31 93 B3 09 E7 86 9D DF 16 D7 59 4A 19 4D F8 80 F2 A7 EC 3F 84 
00 9C D9 AE BB C9 A3 9A 10 6F D5 44 68 7E 59 D0 D1 FE FE FE EA EA 6A 1A 91 F9 3A 36 10 1E FE B7 
DF 7E 5B 53 53 83 7C 84 A0 E2 0E 87 23 1C 0E D7 D4 D4 F0 16 58 21 20 96 4A 13 71 D6 AF 5F 8F F2 
3D E5 04 B9 3C 8B 56 EE 12 D6 9B 3C 3D 3E CE B7 70 5F B8 54 24 05 E3 BF C2 E3 F1 B4 B7 B7 1F 38 
70 A0 BE BE 5E E9 B1 B3 1F 7C F0 41 4D 4D 8D DF EF 4F D0 FA D7 54 5F 0C C3 98 34 69 52 7B 7B 3B 
C3 8B 47 F4 D8 C9 A1 A1 A1 EC EC 6C A5 54 7E 7E FE B8 BE D9 ED 76 77 76 76 26 26 26 CE 9F 3F DF 
ED 76 9F 38 71 A2 A1 A1 61 70 70 90 C0 95 C5 0D C5 B6 AB AB 2B 1C 0E EF D9 B3 C7 6E B7 7B BD DE 
E9 D3 A7 17 14 14 30 88 57 E9 EA 5C 38 1C BE 7D FB F6 CD 9B 37 BB BB BB 09 B5 41 3E 78 5B 51 DD 
21 6A 18 46 7F 7F 7F 79 79 F9 CA 95 2B 4B 4B 4B A9 DE 42 8F 84 9D F3 C7 43 B6 41 97 CB F5 F0 C3 
0F 37 37 37 5F BC 78 D1 EB F5 72 A9 D4 18 28 9C 34 35 35 35 36 36 CE 9E 3D 9B 6E E3 50 28 D4 DE 
DE EE F3 F9 C6 C6 C6 92 92 92 5C 2E 17 75 1A 42 91 89 13 27 4E 9B 36 ED DE BD 7B D5 D5 D5 FB F6 
ED 53 4A 41 50 B6 58 2C 50 8A 95 52 97 2F 5F 6E 69 69 29 2C 2C 2C 2A 2A E2 84 C1 60 B0 A5 A5 85 
28 9A CB 13 0A 81 C7 E3 E9 ED ED BD FF FE FB 2B 2A 2A E8 F3 22 EE 02 58 A2 5A 2D 86 6B C4 4D B3 
93 C5 C6 76 31 5E 52 80 DD 58 34 C9 4E 7E 1F CF 25 EB 33 51 8F 79 62 49 30 45 4F E9 C6 22 0A C8 
A3 5A 80 03 07 41 A6 84 42 27 C5 7D 31 26 C9 E4 31 65 9B A6 25 E2 3A 31 44 BC 95 7C 44 C5 91 3C 
4D 2D 1D C2 07 93 93 93 D7 AC 59 73 F4 E8 D1 B4 B4 B4 FE FE FE A1 A1 21 21 66 45 22 91 BA BA BA 
A6 A6 A6 A2 A2 A2 AC AC AC D4 D4 D4 91 91 91 CB 97 2F E3 46 49 37 78 D7 A2 34 65 B1 58 16 2D 5A 
94 9E 9E 9E 95 95 D5 D9 D9 49 AD 8E D7 07 A5 4E C5 31 DD 2C 5A E5 DD D0 83 83 E5 A7 5C FF A8 D6 
68 F4 7A BD 88 A0 26 24 24 34 36 36 EE DD BB 97 A6 3F 43 B7 04 9A A6 79 FE FC F9 F3 E7 CF 97 94 
94 94 96 96 96 97 97 33 B6 C4 EF F7 5F BA 74 E9 EA D5 AB 32 98 99 79 0D 32 14 6C CE 9C 39 E3 AE 
C6 DE DE 5E B7 DB 0D 5E 92 97 97 F7 EC B3 CF 96 94 94 1C 3F 7E 3C 10 08 E0 63 28 FA 41 4C C3 3A 
A3 D1 68 30 18 EC EB EB 3B 7B F6 2C 06 C4 72 8A C7 0F A5 C8 26 72 EE 22 76 80 47 AC AA AA 9A 37 
6F DE AC 59 B3 88 30 AD 56 2B B4 D8 F1 82 61 9E 0B C1 76 7E 7E FE CA 95 2B AF 5D BB 76 E7 CE 1D 
AB 9E 7A 8B 6E 17 57 38 61 C2 84 E6 E6 E6 B6 B6 36 A1 47 C8 49 00 6F 79 FD 19 19 19 3B 77 EE 64 
B5 CC 9B 37 AF A2 A2 A2 A9 A9 89 1A 89 C5 62 61 6F 34 B4 E8 D8 8D 1B 37 18 6F CE B2 41 E1 97 EF 
B2 DB ED 7D 7D 7D 4A 29 97 CB D5 DB DB 9B 91 91 B1 62 C5 0A 14 DF E0 15 08 E5 0A 97 2F 85 32 99 
94 18 7F 80 FD 8E 87 D4 5B E2 0E 89 DE 41 04 F8 14 A6 26 46 06 B9 8A 00 CF A1 67 FB 60 CA 92 5D 
1B BA 01 D2 D0 FD 4D 18 3A B5 6C 7E 24 94 23 A2 4A 96 3A DC 63 4A 85 42 81 42 E7 DB 88 53 A6 91 
C5 A9 94 22 01 79 F2 C9 27 69 52 E5 0C 30 F2 EC 76 3B 35 A7 81 81 01 1A ED AD BA EB 05 9B 61 19 
B0 DD D1 B7 41 46 53 5D 5D AD 94 BA 79 F3 26 14 45 A1 6A 19 7A 2E 68 54 CF 77 A1 FD 40 69 45 18 
D6 AD 6C EC 56 2D 60 6D B1 58 30 2D 88 6C 47 8E 1C 81 A8 44 6D 4C E9 2A 34 1E AD B5 B5 D5 E7 F3 
49 57 31 C6 C3 26 0C F1 9B CE 78 38 83 05 05 05 0B 16 2C 18 97 31 44 D7 05 FB 12 5F B9 78 F1 E2 
97 5F 7E F9 D1 47 1F A5 E0 63 9A 26 CC 6F 98 3E 4A A3 1D 2C BF 04 2D 61 24 0B 46 60 2E AC 8D D2 
1F 1E 02 2A 4C 49 49 C9 B6 6D DB D6 AC 59 33 7D FA 74 22 69 79 DC 7F 81 89 59 F5 08 07 8B C5 42 
AF FA 9A 35 6B 60 93 F2 86 C2 E1 30 0B 09 14 0E 53 13 24 80 2B 8F 44 22 D9 D9 D9 C3 C3 C3 81 40 
60 D2 A4 49 D5 D5 D5 78 1C 00 F7 4D 9B 36 65 64 64 18 86 E1 76 BB 45 2C E3 8F 61 24 FF 84 A9 E7 
70 38 06 06 06 A0 E0 61 C7 99 99 99 4F 3D F5 D4 E2 C5 8B 41 DE 94 52 50 CF C4 44 94 66 0B 4A 0A 
2A 6B 4C F0 AA BF 40 23 AC FA B0 69 36 6C 4C F7 FE 18 7A D4 94 D2 40 14 7B 51 5A 5A 5A 7A 7A 3A 
A9 81 A1 5B EC 79 7D AC 37 21 B5 41 D3 23 6B 20 BD E7 62 20 D0 99 9A FF 9D 90 90 E0 72 B9 18 82 
C2 DD D1 61 47 41 82 2E 07 D9 7B 95 52 E4 20 C2 C1 80 B4 F8 D6 5B 6F C1 50 E9 EF EF 67 88 F2 C0 
C0 00 D4 42 89 15 F1 08 F1 E0 99 AC 4F 76 48 C3 30 F6 EC D9 C3 EB C8 CA CA A2 F9 90 87 09 5E C0 
6A B7 E8 36 F7 81 81 01 19 C6 8A AD 46 F5 EC 09 CE C6 5D 13 0F B3 8C 93 92 92 DE 7E FB 6D 06 F8 
40 4D C3 92 EF DD BB 37 AA 87 CF 02 8B F2 B4 C7 C6 C6 58 4D 23 23 23 83 83 83 83 83 83 29 29 29 
12 3A 6D DC B8 31 3D 3D 7D DC BD 11 7B 4A 4C 4C 44 F3 9F A1 2E E5 E5 E5 53 A6 4C E9 E9 E9 69 68 
68 A8 AB AB 63 B6 A9 34 F5 2A DD 25 8C 4D B0 45 48 28 02 37 62 4C 1F E4 1E C3 C3 C3 A1 50 A8 A4 
A4 A4 AA AA 8A E6 6B C1 72 B8 0D F1 64 E3 45 68 2C 2D C6 C1 33 25 E2 B1 C7 1E 73 38 1C 87 0F 1F 
C6 80 A0 89 8E E8 39 47 B8 43 49 1B C0 57 9C 4E 67 30 18 8C C5 62 5E AF 77 C7 8E 1D 34 34 0D 0E 
0E 7A BD 5E 4A 29 EF BF FF FE D6 AD 5B 9B 9B 9B 11 BC 93 7C 58 50 56 6E 5C 4A BA B2 DA B9 BC A4 
A4 A4 F5 EB D7 CF 9D 3B 37 A6 A5 D3 86 86 86 70 C9 62 9A 76 3D 03 9C D5 2B E9 8D 6C 77 A6 9E DA 
FD A7 CF 41 B0 22 BC BE AC 2E 41 83 71 FF A6 69 8A BA 82 35 AE 0D 05 D1 61 9B 6E 88 E1 B2 47 46 
46 A4 93 5D 96 81 D0 D0 B9 12 8A E0 12 89 60 76 28 44 AB 38 95 1D 2C 5B B2 68 89 06 B1 04 58 C1 
A4 1B 09 09 09 3B 76 EC D8 BF 7F 7F 47 47 07 C2 0B 36 AD 67 0D 25 95 87 06 F7 8D 74 89 6F 34 35 
F3 36 27 27 E7 22 31 D5 24 00 00 05 42 49 44 41 54 C5 17 5F 2C 2E 2E 96 39 19 B4 2B 18 BA A3 8D 
09 D0 4A 8F 61 C7 7B 62 96 86 1E FB C7 E4 E6 98 AE DA 5B E2 24 F9 E0 8D 32 5C 10 ED 88 2F BE F8 
82 34 07 9F 42 1D 5B 29 C5 FC 28 6E 56 FC 20 BE C3 66 B3 D1 3C E8 F1 78 9E 78 E2 89 9C 9C 9C 48 
24 32 EE 6A C4 5C 84 F9 CA 34 4F BF DF CF B4 83 E5 CB 97 57 56 56 5E BA 74 A9 AE AE AE AD AD 2D 
A6 5B 07 94 0E C1 A5 E3 81 8A 1C B7 11 1F 6B 61 FA 95 95 95 95 95 95 EC 4B 50 E4 D8 69 4D CD 2E 
60 EB 57 E3 53 3A 4D D3 14 0D 76 9C 96 D7 EB 7D F8 E1 87 3D 1E CF B1 63 C7 5A 5B 5B 59 DB 18 22 
C8 2D 7F 37 E2 F4 6D B9 C2 47 1E 79 E4 99 67 9E C1 61 D3 68 C3 2E 41 C5 75 D7 AE 5D 5F 7D F5 55 
6D 6D 6D 82 56 A9 04 9B B6 EA D6 21 A5 C9 3A 5C 12 DB B2 52 EA A1 87 1E AA AA AA CA CB CB 1B 19 
19 89 44 22 1E 8F 27 AA 35 10 84 3A C7 03 21 9C 4E 4E 4E 06 88 92 02 89 6C 3E C2 E9 FB D3 E7 30 
A6 85 54 6C 7A 90 0E AF 00 AF 87 6F 95 08 85 05 2C AC 31 D2 3F 00 6D 59 42 EC 8A 6C 08 EC 69 91 
48 04 1D 2A B9 72 09 3E 79 C5 A6 2E 6A E3 8E E9 6E B5 E8 C9 25 00 F2 44 80 38 02 A5 27 26 10 BF 
50 15 B0 D9 6C AF BD F6 5A 6D 6D ED 77 DF 7D 47 F2 CF 22 21 9E E7 F2 84 0C CC 43 4E D4 1A C7 0B 
17 2E 7C FA E9 A7 79 14 04 0B 74 60 A7 A7 A7 3B 1C 0E 2A C0 3C 10 00 76 CE 49 E8 44 A4 CD 63 C9 
C9 C9 81 E5 82 79 D8 B5 18 07 AF D5 6E B7 F7 F4 F4 E4 E6 E6 86 C3 E1 55 AB 56 95 95 95 1D 3C 78 
F0 D6 AD 5B CC 53 12 89 03 62 43 31 5D 8C 59 16 39 D2 DE 5B B6 6C 99 3D 7B 76 42 42 82 DF EF 1F 
77 35 12 D7 D1 97 00 88 C4 03 A5 8D 83 06 F9 65 CB 96 2D 5B B6 EC D6 AD 5B 4C 4A F8 ED B7 DF 18 
B3 01 E0 26 4F 2A DE 5B A7 A6 A6 CE 9C 39 73 FA F4 E9 8B 17 2F 26 5A E0 1D 10 11 C9 2F 0B 80 C1 
02 63 23 FD D3 EB 14 CB A3 D2 CA 5C 64 A5 D4 92 25 4B 0A 0B 0B 1B 1B 1B CF 9C 39 83 68 B7 F8 6F 
5A 3A 62 BA 2A 35 61 C2 84 DC DC DC D5 AB 57 2F 5C B8 D0 E7 F3 59 75 D7 29 99 0F 80 13 60 D2 E3 
8F 3F 3E 77 EE DC 0B 17 2E D4 D6 D6 3A 9D 4E 64 5A 55 5C 4A 40 14 80 AB B6 5A AD A5 A5 A5 CB 97 
2F 2F 2F 2F 97 6F 94 CC 13 FB 93 99 93 76 2D 47 4F 84 DF D9 D9 99 9F 9F 6F 89 13 7D B0 6A D1 7B 
EB 38 ED 08 48 81 E0 68 64 47 35 4D D3 EF F7 93 16 02 E7 F0 18 B9 1E 2E 12 2C 9D 37 25 B8 97 EC 
5D 04 DB F8 62 24 E4 58 93 1E 8F 87 1F 45 B5 8C 1D 70 3A 24 44 36 7F 76 1E E0 B1 48 24 82 C2 3A 
E1 A5 78 0D F2 E7 BB 77 EF A6 A7 A7 07 02 81 CC CC 4C C2 6C 97 CB B5 61 C3 86 AA AA AA 4F 3E F9 
A4 B5 B5 55 12 33 A5 FB A1 59 EA 18 2A 1B F8 83 0F 3E B8 62 C5 8A E2 E2 E2 FE FE FE EC EC 6C 7A 
F9 6D 7A FC 41 28 14 12 0E 86 CB E5 A2 70 CF 4D 8D 8D 8D A1 2D 28 F9 B0 CD 66 0B 85 42 0C D2 C2 
3D 19 7A F4 10 50 88 52 2A 27 27 C7 E7 F3 A5 A6 A6 3A 1C 8E EC EC EC DD BB 77 FF FC F3 CF DF 7C 
F3 0D 52 7D 58 B5 38 0E 80 6B 30 76 FA D4 12 13 13 57 AF 5E 5D 56 56 E6 76 BB 95 52 C1 60 B0 B0 
B0 D0 F2 F9 E7 9F 8F B7 20 01 A9 6D 5A DD 00 00 4D D0 17 BC 45 54 AB 1E 59 B5 6C 44 20 10 08 04 
02 28 1D 49 8C 0A B4 E5 F5 7A 45 EC 88 CA 0A 27 27 C0 60 DB 94 04 40 E9 28 94 85 3A DE 9E 00 31 
20 33 33 53 69 3C 8D AB 05 14 01 49 F3 F9 7C BF FE FA EB F5 EB D7 BB BB BB 91 26 88 C5 62 13 27 
4E 2C 2A 2A 2A 2A 2A 2A 29 29 29 2E 2E 86 6F 50 50 50 D0 D3 D3 23 AB 42 30 64 C4 0A 50 AD A7 50 
D1 DA DA 8A 62 3A 13 54 08 A2 D2 D2 D2 9C 4E 67 5E 5E DE FC F9 F3 8B 8B 8B 93 92 92 88 2F 84 7F 
47 7C 3B 36 36 E6 F5 7A 6F DC B8 11 0C 06 89 02 E8 B7 26 01 EE ED ED 7D E0 81 07 E2 1B A9 D0 F2 
70 38 1C 7E BF 1F 51 FD 3F 1E E8 FF 93 AD 11 02 C8 A6 7A EE DC B9 CC CC 4C FA AA 41 DB A1 B0 64 
65 65 B9 DD 6E D0 66 52 3E CA 77 BC DC BE BE 3E 6C 05 DC 8F 79 52 4C BF 70 3A 9D 75 75 75 A8 F5 
E0 4D 40 DA BA BB BB 0B 0B 0B 73 72 72 78 05 0E 87 83 F1 81 C3 C3 C3 19 19 19 3F FC F0 03 B4 27 
33 6E E8 5D 28 14 CA CF CF 9F 3C 79 32 5E 2F 18 0C 8E 8E 8E 4E 9E 3C 19 3F 68 18 06 13 35 DA DB 
DB AF 5C B9 72 FD FA 75 22 DB EE EE 6E B7 DB 9D 9C 9C 3C 71 E2 C4 A9 53 A7 CE 99 33 A7 B8 B8 98 
C1 8F 86 61 A0 A1 4A 3E EC 72 B9 08 0A 2C 16 4B 53 53 13 37 62 D5 E2 B1 94 94 B2 B2 B2 A6 4C 99 
82 8B 34 35 3F C6 34 CD F4 F4 F4 D3 A7 4F 8B 96 0A 2E 20 1A 8D 92 1B 4F 9E 3C 19 67 1A 0E 87 81 
EE 88 8C 02 81 00 C0 DE ED DB B7 EF DE BD 8B F2 2D 1E 2D 35 35 75 D2 A4 49 33 67 CE 9C 31 63 C6 
7D F7 DD 37 3A 3A 4A 5E CA 68 5A A5 D4 FF 00 83 A1 E3 CA 83 5D 76 DD 00 00 00 00 49 45 4E 44 AE 
42 60 82 
EndData
$EndBitmap
Text Notes 1550 5750 0    79   ~ 0
Attribution 4.0 International
Wire Wire Line
	2100 3350 2350 3350
Wire Wire Line
	2350 4275 2350 4150
Wire Wire Line
	2350 3850 2350 3350
Connection ~ 2350 3350
Wire Wire Line
	2350 3350 3000 3350
Wire Notes Line
	2650 3825 1775 3825
Wire Notes Line
	1775 3825 1775 4250
Wire Notes Line
	1775 4250 2650 4250
Wire Notes Line
	2650 4250 2650 3825
Wire Wire Line
	1500 3350 1500 3250
Wire Wire Line
	1500 2950 1500 2875
Text Notes 1225 4500 0    50   ~ 0
Rdet1 = Rout_Q3 + Rd1\ntaud1=Cdet*Rdet1; \nsee explanation
Text Notes 2625 2375 0    50   ~ 0
Cr=Cr1+Cr2+parasitics
Wire Wire Line
	3375 3775 3600 3775
Connection ~ 3600 3775
Wire Wire Line
	3600 3775 3600 3850
Text Notes 550  3650 0    50   ~ 0
detector \nvoltage test \npoint
Connection ~ 6775 1175
Wire Wire Line
	6775 1175 7100 1175
Text Notes 6725 1925 0    50   ~ 0
auxiliary/frequency
Wire Notes Line
	1725 2875 1725 3825
Wire Notes Line
	1725 3825 1375 3825
Wire Notes Line
	1375 3825 1375 2875
Wire Notes Line
	1375 2875 1725 2875
Wire Notes Line
	3875 3650 3450 3650
Text Notes 1750 2850 0    50   ~ 0
Rdet2=R1||R2\ntaud2=Cdet*Rdet2; \nsee explanation
Text Notes 500  2125 0    50   ~ 0
EXAMPLE\nThe resonant circuit\nCr=47pF  and Lr=1uH;\nZo = sqrt(1uH/47pF) = 146 ohm (=> in the proper range).\nfr = 1/(2*pi*sqrt(Lr*Cr)) = 23.2MHz.\nTr= 1/fr = 43ns.\n\nThe detector (simplified approach)\ntaud1 should be in a range of 1.2*Tr  .. 4*Tr, \nfor example taud1 = 90ns.\nCdet = taud1/Rdet1 = 90ns/30 ohm = 3nF (ca).\ntaud2 should be not less than 15*taud1\n=> and that is assured by the value of ratio Rdet2/Rdet1.
$EndSCHEMATC
